/**
 * @file WblDbusLastIntendedModeFactory.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl instance factory for LastIntendedMode.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl instance factory for LastIntendedMode.
 */

#ifndef _WBL_DBUS_LAST_INTENDED_MODE_FACTORY_H_
#define _WBL_DBUS_LAST_INTENDED_MODE_FACTORY_H_

#include "IWblDbusLastIntendedModeSendRequestIf.h"

namespace ccdbusif {

// class forward declarations
class IWblDbusLastIntendedModeTestProxyIf;
class ICcDbusIfControllerClient;

namespace wbl {

/**
 *
 */
class WblDbusLastIntendedModeFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static WblDbusLastIntendedModeFactory& getInstance(void);

   /**
    * Get proxy (pointer).
    *
    * @param[in] client: controller client
    *
    * @return = pointer to proxy
    */
   IWblDbusLastIntendedModeSendRequestIf* getProxy(ICcDbusIfControllerClient* client);

   /**
    * Destroy proxy (pointer).
    */
   void destroyProxy(void);

   /**
    * Set test proxy (pointer).
    * For testing purpose (unit test).
    *
    * @param[in] testProxy: test version of proxy (pointer)
    */
   void setProxyForTesting(IWblDbusLastIntendedModeTestProxyIf* testProxy);

private:
   /**
    * Default constructor. Private!!!
    */
   WblDbusLastIntendedModeFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~WblDbusLastIntendedModeFactory();

   IWblDbusLastIntendedModeSendRequestIf* _proxy; /**< proxy */
   IWblDbusLastIntendedModeTestProxyIf* _testProxy; /**< test proxy */
};

} //wbl
} //ccdbusif

#endif //_WBL_DBUS_LAST_INTENDED_MODE_FACTORY_H_
