/**
 * @file WblDbusConflictManagementProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl DBUS proxy for ConflictManagement.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Wbl DBUS proxy for ConflictManagement.
 */

#ifndef _WBL_DBUS_CONFLICT_MANAGEMENT_PROXY_IF_H_
#define _WBL_DBUS_CONFLICT_MANAGEMENT_PROXY_IF_H_

#include "ISetCallback.h"
#include "ICreateProxy.h"
#include "IDestroyProxy.h"
#include "IDestroyAllProxies.h"
#include "IWblDbusConflictManagementSendRequestIf.h"
#include "IWblDbusConflictManagementCallbackIf.h"
#include "IWblDbusConflictManagementTestProxyIf.h"
#include "DbusBaseProxyIf.h"

#include "asf/core/Proxy.h" // ServiceAvailableIF
#include "org/bosch/wbl/conflictmanagementProxy.h"

using namespace ::asf::core;
using namespace ::org::bosch::wbl::conflictmanagement;

namespace ccdbusif {
namespace wbl {

/**
 * ConflictManagement proxy class for Wbl interface.
 */
class WblDbusConflictManagementProxyIf :
   public ServiceAvailableIF,
   public ISetCallback< IWblDbusConflictManagementCallbackIf >,
   public ICreateProxy,
   public IDestroyProxy,
   public IDestroyAllProxies,
   public IWblDbusConflictManagementSendRequestIf,
   public PrepareSetupCallbackIF,
   public DeActivateSetupCallbackIF,
   public WiFiStationModeUsageCallbackIF,
   public ResolveConflictCallbackIF,
   public ConflictDetectedCallbackIF,
   public ConflictResolvedCallbackIF,
   public ActiveWiFiSetupsCallbackIF,
   public WiFiPriorityListCallbackIF,
   public ConfigurationTimerCallbackIF,
   public IWblDbusConflictManagementCallbackIf,
   public DbusBaseProxyIf< IWblDbusConflictManagementCallbackIf, ConflictmanagementProxy, IWblDbusConflictManagementTestProxyIf >
{
public:
   WblDbusConflictManagementProxyIf(ICcDbusIfControllerClient* client);

   WblDbusConflictManagementProxyIf(ICcDbusIfControllerClient* client, IWblDbusConflictManagementTestProxyIf* testProxyIf);

   virtual ~WblDbusConflictManagementProxyIf();

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange);

   virtual void onUnavailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   virtual void handleSetCallback(IWblDbusConflictManagementCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleCreateProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyAllProxies(void);

   virtual void handleDestroyAllRuntimeProxies(void);

   // IWblDbusConflictManagementSendRequestIf implementation --- start
   virtual IDestroyAllProxies* getDestroyer(void);

   virtual void setCallbackIf(IWblDbusConflictManagementCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void createProxyIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void destroyProxyIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual act_t sendPrepareSetupRequest(const unsigned int callbackId, const ::std::string& wiFiMode);

   virtual act_t sendDeActivateSetupRequest(const unsigned int callbackId, const ::std::string& wiFiMode);

   virtual act_t sendWiFiStationModeUsageRequest(const unsigned int callbackId, const ::std::string& application, const ::std::string& usage, bool holding);

   virtual act_t sendResolveConflictRequest(const unsigned int callbackId, int32 conflictid, int32 action);

   virtual act_t sendActiveWiFiSetupsGet(const unsigned int callbackId);

   virtual act_t sendWiFiPriorityListGet(const unsigned int callbackId);

   virtual void sendWiFiPriorityListSet(const unsigned int callbackId, const ::std::vector< ::std::string >& wiFiPriorityList);

   virtual act_t sendConfigurationTimerGet(const unsigned int callbackId);

   virtual void sendConfigurationTimerSet(const unsigned int callbackId, int32 configurationTimer);
   // IWblDbusConflictManagementSendRequestIf implementation --- end

   // CallbackIF implementation --- start
   virtual void onPrepareSetupError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< PrepareSetupError >& error);

   virtual void onPrepareSetupResponse(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< PrepareSetupResponse >& response);

   virtual void onDeActivateSetupError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< DeActivateSetupError >& error);

   virtual void onDeActivateSetupResponse(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< DeActivateSetupResponse >& response);

   virtual void onWiFiStationModeUsageError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< WiFiStationModeUsageError >& error);

   virtual void onWiFiStationModeUsageResponse(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< WiFiStationModeUsageResponse >& response);

   virtual void onResolveConflictError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ResolveConflictError >& error);

   virtual void onResolveConflictResponse(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ResolveConflictResponse >& response);

   virtual void onConflictDetectedError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ConflictDetectedError >& error);

   virtual void onConflictDetectedSignal(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ConflictDetectedSignal >& signal);

   virtual void onConflictResolvedError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ConflictResolvedError >& error);

   virtual void onConflictResolvedSignal(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ConflictResolvedSignal >& signal);

   virtual void onActiveWiFiSetupsError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ActiveWiFiSetupsError >& error);

   virtual void onActiveWiFiSetupsUpdate(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ActiveWiFiSetupsUpdate >& update);

   virtual void onWiFiPriorityListError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< WiFiPriorityListError >& error);

   virtual void onWiFiPriorityListUpdate(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< WiFiPriorityListUpdate >& update);

   virtual void onConfigurationTimerError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ConfigurationTimerError >& error);

   virtual void onConfigurationTimerUpdate(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ConfigurationTimerUpdate >& update);
   // CallbackIF implementation --- end

   // IWblDbusConflictManagementCallbackIf implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void onPrepareSetupErrorCb(const ::boost::shared_ptr< PrepareSetupError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPrepareSetupResponseCb(const ::boost::shared_ptr< PrepareSetupResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeActivateSetupErrorCb(const ::boost::shared_ptr< DeActivateSetupError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeActivateSetupResponseCb(const ::boost::shared_ptr< DeActivateSetupResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onWiFiStationModeUsageErrorCb(const ::boost::shared_ptr< WiFiStationModeUsageError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onWiFiStationModeUsageResponseCb(const ::boost::shared_ptr< WiFiStationModeUsageResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onResolveConflictErrorCb(const ::boost::shared_ptr< ResolveConflictError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onResolveConflictResponseCb(const ::boost::shared_ptr< ResolveConflictResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onConflictDetectedErrorCb(const ::boost::shared_ptr< ConflictDetectedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onConflictDetectedSignalCb(const ::boost::shared_ptr< ConflictDetectedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onConflictResolvedErrorCb(const ::boost::shared_ptr< ConflictResolvedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onConflictResolvedSignalCb(const ::boost::shared_ptr< ConflictResolvedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onActiveWiFiSetupsErrorCb(const ::boost::shared_ptr< ActiveWiFiSetupsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onActiveWiFiSetupsUpdateCb(const ::boost::shared_ptr< ActiveWiFiSetupsUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onWiFiPriorityListErrorCb(const ::boost::shared_ptr< WiFiPriorityListError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onWiFiPriorityListUpdateCb(const ::boost::shared_ptr< WiFiPriorityListUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onConfigurationTimerErrorCb(const ::boost::shared_ptr< ConfigurationTimerError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onConfigurationTimerUpdateCb(const ::boost::shared_ptr< ConfigurationTimerUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());
   // IWblDbusConflictManagementCallbackIf implementation --- end

protected:
   virtual void internalCreateProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyAllProxies(void);

   virtual void internalDestroyAllRuntimeProxies(void);

   void internalOnAvailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   void internalOnUnavailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);
};

} //wbl
} //ccdbusif

#endif //_WBL_DBUS_CONFLICT_MANAGEMENT_PROXY_IF_H_
