/**
 * @file IWblDbusLastIntendedModeSendRequestIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl DBUS Send Request Interface for LastIntendedMode.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for Wbl DBUS send request for LastIntendedMode.
 */

#ifndef _I_WBL_DBUS_LAST_INTENDED_MODE_SEND_REQUEST_IF_H_
#define _I_WBL_DBUS_LAST_INTENDED_MODE_SEND_REQUEST_IF_H_

#include "CcDbusIfTypes.h"

namespace ccdbusif {

// class forward declarations
class IDestroyAllProxies;
class IWblDbusLastIntendedModeCallbackIf;

/**
 * Send request interface class for LastIntendedMode.
 */
class IWblDbusLastIntendedModeSendRequestIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IWblDbusLastIntendedModeSendRequestIf() {}

   /**
    * Get destroy interface.
    *
    * @return = destroy interface
    */
   virtual IDestroyAllProxies* getDestroyer(void) = 0;

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableProxy: flag to enable/disable proxy
    * @param[in] callbackId: callback id
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void setCallbackIf(IWblDbusLastIntendedModeCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Create proxy interface.
    *
    * @param[in] callbackId: callback id
    * @param[in] createDirectly: flag to trigger direct proxy creation or via work item request
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void createProxyIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Destroy proxy interface.
    *
    * @param[in] callbackId: callback id
    * @param[in] destroyDirectly: flag to trigger direct proxy destruction or via work item request
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void destroyProxyIf(const unsigned int callbackId, const bool destroyDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Send LastIntendedMode Get.
    *
    * @param[in] callbackId: callback id
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendLastIntendedModeGet(const unsigned int callbackId) = 0;
};

} //ccdbusif

#endif //_I_WBL_DBUS_LAST_INTENDED_MODE_SEND_REQUEST_IF_H_
