/**
 * @file IWblDbusLastIntendedModeCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Wbl DBUS Callback Interface for LastIntendedMode.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for Wbl DBUS callback for LastIntendedMode.
 */

#ifndef _I_WBL_DBUS_LAST_INTENDED_MODE_CALLBACK_IF_H_
#define _I_WBL_DBUS_LAST_INTENDED_MODE_CALLBACK_IF_H_

#include "CcDbusIfTypes.h"

#include "org/bosch/wbl/LastIntendedMode.h"

using namespace ::org::bosch::wbl::LastIntendedMode;

namespace ccdbusif {

/**
 * Callback interface class for LastIntendedMode.
 */
class IWblDbusLastIntendedModeCallbackIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IWblDbusLastIntendedModeCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   /**
    * Available signal.
    *
    * @param[in] available: available flag
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Unavailable signal.
    *
    * @param[in] available: available flag
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bosch/wbl/LastIntendedModeProxy implementation --- start
   /**
    * onLastIntendedModeError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onLastIntendedModeErrorCb(const ::boost::shared_ptr< LastIntendedModeError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onLastIntendedModeUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onLastIntendedModeUpdateCb(const ::boost::shared_ptr< LastIntendedModeUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;
   // org/bosch/wbl/LastIntendedModeProxy implementation --- end
};

} //ccdbusif

#endif //_I_WBL_DBUS_LAST_INTENDED_MODE_CALLBACK_IF_H_
