/**
 * @file PropertiesGetAllProxyManager.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Proxy management for properties get all interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Proxy management for properties get all interface.
 */

#include "PropertiesGetAllProxyManager.h"
#include "IPropertiesGetAllDbusCallbackIf.h"

#define FW_S_IMPORT_INTERFACE_ASSERT
#include "framework_if_if.h"

namespace ccdbusif {

PropertiesGetAllProxyManager::PropertiesGetAllProxyManager()
{
   // _proxyMetaData2CallbackIf
}

PropertiesGetAllProxyManager::PropertiesGetAllProxyManager(const PropertiesGetAllProxyManager& ref)
: ProxyManager< PropertiesProxy >(ref)
{
   _proxyMetaData2CallbackIf = ref._proxyMetaData2CallbackIf;
}

PropertiesGetAllProxyManager& PropertiesGetAllProxyManager::operator=(const PropertiesGetAllProxyManager& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   ProxyManager< PropertiesProxy >::operator=(ref);

   _proxyMetaData2CallbackIf = ref._proxyMetaData2CallbackIf;

   return *this;
}

bool PropertiesGetAllProxyManager::operator==(const PropertiesGetAllProxyManager& ref) const
{
   bool result = ProxyManager< PropertiesProxy >::operator==(ref);

   result = (true == result) && (_proxyMetaData2CallbackIf == ref._proxyMetaData2CallbackIf);

   return result;
}

bool PropertiesGetAllProxyManager::operator!=(const PropertiesGetAllProxyManager& ref) const
{
   return !(operator==(ref));
}

PropertiesGetAllProxyManager::~PropertiesGetAllProxyManager()
{
}

void PropertiesGetAllProxyManager::addCallbackIf(const ProxyMetaData& metaData, IPropertiesGetAllDbusCallbackIf* callback)
{
   ::std::map<ProxyMetaData, IPropertiesGetAllDbusCallbackIf*>::iterator it = _proxyMetaData2CallbackIf.find(metaData);

   if(_proxyMetaData2CallbackIf.end() != it)
   {
      // entry is already stored => can happen because function is called after reception of different signals
   }
   else
   {
      // entry is not stored
      _proxyMetaData2CallbackIf[metaData] = callback;

      // check size
      if(0 < _maxNumberOfProxyInstances)
      {
         if(_proxyMetaData2CallbackIf.size() > _maxNumberOfProxyInstances)
         {
            // should never happen - forgot to remove instance?
            // #error_indication
            FW_NORMAL_ASSERT_ALWAYS();
         }
      }
   }
}

void PropertiesGetAllProxyManager::addCallbackIf(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, IPropertiesGetAllDbusCallbackIf* callback)
{
   (void)(user);
   ProxyMetaData metaData;
   metaData.busName = busName;
   metaData.objPath = objPath;
   metaData.busType = busType;

   addCallbackIf(metaData, callback);
}

void PropertiesGetAllProxyManager::removeCallbackIf(const ProxyMetaData& metaData)
{
   ::std::map<ProxyMetaData, IPropertiesGetAllDbusCallbackIf*>::iterator it = _proxyMetaData2CallbackIf.find(metaData);

   if(_proxyMetaData2CallbackIf.end() == it)
   {
      // entry is already erased => can happen
   }
   else
   {
      // entry is not erased
      _proxyMetaData2CallbackIf.erase(it);
   }
}

void PropertiesGetAllProxyManager::removeCallbackIf(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user)
{
   (void)(user);
   ProxyMetaData metaData;
   metaData.busName = busName;
   metaData.objPath = objPath;
   metaData.busType = busType;

   removeCallbackIf(metaData);
}

IPropertiesGetAllDbusCallbackIf* PropertiesGetAllProxyManager::getCallbackIf(const ProxyMetaData& metaData)
{
   ::std::map<ProxyMetaData, IPropertiesGetAllDbusCallbackIf*>::iterator it = _proxyMetaData2CallbackIf.find(metaData);

   if(_proxyMetaData2CallbackIf.end() != it)
   {
      return it->second;
   }

   return NULL;
}

IPropertiesGetAllDbusCallbackIf* PropertiesGetAllProxyManager::getCallbackIf(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user)
{
   (void)(user);
   ProxyMetaData metaData;
   metaData.busName = busName;
   metaData.objPath = objPath;
   metaData.busType = busType;

   return getCallbackIf(metaData);
}

void PropertiesGetAllProxyManager::removeAllCallbackIfs(void)
{
   _proxyMetaData2CallbackIf.clear();
}

} //ccdbusif
