/**
 * @file PropertiesGetAllDbusProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Properties get all DBUS Proxy.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Properties get all DBUS Proxy.
 */

#ifndef _PROPERTIES_GET_ALL_DBUS_PROXY_IF_H_
#define _PROPERTIES_GET_ALL_DBUS_PROXY_IF_H_

#include "ICcDbusIfDestroyProxy.h"
#include "IPropertiesGetAllCreateRuntimeProxy.h"
#include "IPropertiesGetAllDestroyRuntimeProxy.h"
#include "IPropertiesGetAllDbusSendRequestIf.h"
#include "PropertiesGetAllProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "getall/org/freedesktop/DBus/PropertiesProxy.h"

using namespace ::getall::org::freedesktop::DBus::Properties;

using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IPropertiesGetAllDbusCallbackIf;

/**
 *
 */
class PropertiesGetAllDbusProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfDestroyProxy,
   public IPropertiesGetAllCreateRuntimeProxy,
   public IPropertiesGetAllDestroyRuntimeProxy,
   public IPropertiesGetAllDbusSendRequestIf,
   public BaseDbusProxyIf
{
public:
   PropertiesGetAllDbusProxyIf(ICcDbusIfControllerClient* client);

   virtual ~PropertiesGetAllDbusProxyIf();

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, IPropertiesGetAllDbusCallbackIf* callbackIf);

   virtual void destroyRuntimeProxy(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user);

   virtual void setCallbackIf(IPropertiesGetAllDbusCallbackIf* callbackIf, bool enableProxy, const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // HINT: following interfaces are called within context of thread started in CcDbusIfController.cpp ("CC_DBUS_IF_THD")

   // IPropertiesGetAllDbusSendRequestIf implementation --- start
   virtual act_t sendGetAllRequest(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, const ::std::string& interface);
   // IPropertiesGetAllDbusSendRequestIf implementation --- end

protected:
   PropertiesGetAllDbusProxyIf();

private:
   PropertiesGetAllProxyManager _proxy;
};

} //ccdbusif

#endif //_PROPERTIES_GET_ALL_DBUS_PROXY_IF_H_
