/**
 * @file PropertiesGetAllCreateRuntimeProxyWorkItem.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Create proxy work item for properties get all interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Create proxy work item for properties get all interface.
 */

#ifndef _PROPERTIES_GET_ALL_CREATE_RUNTIME_PROXY_ITEM_H_
#define _PROPERTIES_GET_ALL_CREATE_RUNTIME_PROXY_ITEM_H_

#include "IWorkItem.h"
#include "CcDbusIfTypes.h"

namespace ccdbusif {

// class forward declarations
class IPropertiesGetAllDbusCallbackIf;
class IPropertiesGetAllCreateRuntimeProxy;

/**
 *
 */
class PropertiesGetAllCreateRuntimeProxyWorkItem : public IWorkItem
{
public:
   PropertiesGetAllCreateRuntimeProxyWorkItem(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, IPropertiesGetAllDbusCallbackIf* callback, IPropertiesGetAllCreateRuntimeProxy* creator);
   virtual ~PropertiesGetAllCreateRuntimeProxyWorkItem();
   virtual void processWorkItem(void);

protected:
   PropertiesGetAllCreateRuntimeProxyWorkItem();

private:
   ::std::string _busName;
   ::std::string _objPath;
   DbusBusType _busType;
   void* _user;
   IPropertiesGetAllDbusCallbackIf* _callback;
   IPropertiesGetAllCreateRuntimeProxy* _proxyCreator;
};

} //ccdbusif

#endif //_PROPERTIES_GET_ALL_CREATE_RUNTIME_PROXY_ITEM_H_
