/**
 * @file OrgFreedesktopDbusObjectManagerProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief OrgFreedesktop DBUS proxy for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details OrgFreedesktop DBUS proxy for ObjectManager.
 */

#ifndef _ORG_FREEDESKTOP_DBUS_OBJECT_MANAGER_PROXY_IF_H_
#define _ORG_FREEDESKTOP_DBUS_OBJECT_MANAGER_PROXY_IF_H_

#include "ISetCallback.h"
#include "ICreateProxy.h"
#include "IDestroyProxy.h"
#include "IDestroyAllProxies.h"
#include "IOrgFreedesktopDbusObjectManagerSendRequestIf.h"
#include "IOrgFreedesktopDbusObjectManagerCallbackIf.h"
#include "IOrgFreedesktopDbusObjectManagerTestProxyIf.h"
#include "DbusBaseProxyIf.h"

#include "asf/core/Proxy.h" // ServiceAvailableIF
#include "objmgr/org/freedesktop/DBus/ObjectManagerProxy.h"

using namespace ::asf::core;
using namespace ::objmgr::org::freedesktop::DBus::ObjectManager;

namespace ccdbusif {
namespace freedesktop {

/**
 * ObjectManager proxy class for OrgFreedesktop interface.
 */
class OrgFreedesktopDbusObjectManagerProxyIf :
   public ServiceAvailableIF,
   public ISetCallback< IOrgFreedesktopDbusObjectManagerCallbackIf >,
   public ICreateProxy,
   public IDestroyProxy,
   public IDestroyAllProxies,
   public IOrgFreedesktopDbusObjectManagerSendRequestIf,
   public GetManagedObjectsCallbackIF,
   public InterfacesAddedCallbackIF,
   public InterfacesRemovedCallbackIF,
   public IOrgFreedesktopDbusObjectManagerCallbackIf,
   public DbusBaseProxyIf< IOrgFreedesktopDbusObjectManagerCallbackIf, ObjectManagerProxy, IOrgFreedesktopDbusObjectManagerTestProxyIf >
{
public:
   OrgFreedesktopDbusObjectManagerProxyIf(ICcDbusIfControllerClient* client);

   OrgFreedesktopDbusObjectManagerProxyIf(ICcDbusIfControllerClient* client, IOrgFreedesktopDbusObjectManagerTestProxyIf* testProxyIf);

   virtual ~OrgFreedesktopDbusObjectManagerProxyIf();

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange);

   virtual void onUnavailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   virtual void handleSetCallback(IOrgFreedesktopDbusObjectManagerCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleCreateProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyAllProxies(void);

   virtual void handleDestroyAllRuntimeProxies(void);

   // IOrgFreedesktopDbusObjectManagerSendRequestIf implementation --- start
   virtual IDestroyAllProxies* getDestroyer(void);

   virtual void setCallbackIf(IOrgFreedesktopDbusObjectManagerCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void createProxyIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void destroyProxyIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual act_t sendGetManagedObjectsRequest(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);
   // IOrgFreedesktopDbusObjectManagerSendRequestIf implementation --- end

   // CallbackIF implementation --- start
   virtual void onGetManagedObjectsError(const ::boost::shared_ptr< ObjectManagerProxy >& proxy, const ::boost::shared_ptr< GetManagedObjectsError >& error);

   virtual void onGetManagedObjectsResponse(const ::boost::shared_ptr< ObjectManagerProxy >& proxy, const ::boost::shared_ptr< GetManagedObjectsResponse >& response);

   virtual void onInterfacesAddedError(const ::boost::shared_ptr< ObjectManagerProxy >& proxy, const ::boost::shared_ptr< InterfacesAddedError >& error);

   virtual void onInterfacesAddedSignal(const ::boost::shared_ptr< ObjectManagerProxy >& proxy, const ::boost::shared_ptr< InterfacesAddedSignal >& signal);

   virtual void onInterfacesRemovedError(const ::boost::shared_ptr< ObjectManagerProxy >& proxy, const ::boost::shared_ptr< InterfacesRemovedError >& error);

   virtual void onInterfacesRemovedSignal(const ::boost::shared_ptr< ObjectManagerProxy >& proxy, const ::boost::shared_ptr< InterfacesRemovedSignal >& signal);
   // CallbackIF implementation --- end

   // IOrgFreedesktopDbusObjectManagerCallbackIf implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void onGetManagedObjectsErrorCb(const ::boost::shared_ptr< GetManagedObjectsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onGetManagedObjectsResponseCb(const ::boost::shared_ptr< GetManagedObjectsResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesAddedErrorCb(const ::boost::shared_ptr< InterfacesAddedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesAddedSignalCb(const ::boost::shared_ptr< InterfacesAddedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesRemovedErrorCb(const ::boost::shared_ptr< InterfacesRemovedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onInterfacesRemovedSignalCb(const ::boost::shared_ptr< InterfacesRemovedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());
   // IOrgFreedesktopDbusObjectManagerCallbackIf implementation --- end

protected:
   virtual void internalCreateProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyAllProxies(void);

   virtual void internalDestroyAllRuntimeProxies(void);

   void internalOnAvailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   void internalOnUnavailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

private:
   const ::std::string _portObjectManager;
};

} //freedesktop
} //ccdbusif

#endif //_ORG_FREEDESKTOP_DBUS_OBJECT_MANAGER_PROXY_IF_H_
