/**
 * @file OrgFreedesktopDbusObjectManagerFactory.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief OrgFreedesktop instance factory for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details OrgFreedesktop instance factory for ObjectManager.
 */

#ifndef _ORG_FREEDESKTOP_DBUS_OBJECT_MANAGER_FACTORY_H_
#define _ORG_FREEDESKTOP_DBUS_OBJECT_MANAGER_FACTORY_H_

#include "IOrgFreedesktopDbusObjectManagerSendRequestIf.h"

namespace ccdbusif {

// class forward declarations
class IOrgFreedesktopDbusObjectManagerTestProxyIf;
class ICcDbusIfControllerClient;

namespace freedesktop {

/**
 *
 */
class OrgFreedesktopDbusObjectManagerFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static OrgFreedesktopDbusObjectManagerFactory& getInstance(void);

   /**
    * Get proxy (pointer).
    *
    * @param[in] client: controller client
    *
    * @return = pointer to proxy
    */
   IOrgFreedesktopDbusObjectManagerSendRequestIf* getProxy(ICcDbusIfControllerClient* client);

   /**
    * Destroy proxy (pointer).
    */
   void destroyProxy(void);

   /**
    * Set test proxy (pointer).
    * For testing purpose (unit test).
    *
    * @param[in] testProxy: test version of proxy (pointer)
    */
   void setProxyForTesting(IOrgFreedesktopDbusObjectManagerTestProxyIf* testProxy);

private:
   /**
    * Default constructor. Private!!!
    */
   OrgFreedesktopDbusObjectManagerFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~OrgFreedesktopDbusObjectManagerFactory();

   IOrgFreedesktopDbusObjectManagerSendRequestIf* _proxy; /**< proxy */
   IOrgFreedesktopDbusObjectManagerTestProxyIf* _testProxy; /**< test proxy */
};

} //freedesktop
} //ccdbusif

#endif //_ORG_FREEDESKTOP_DBUS_OBJECT_MANAGER_FACTORY_H_
