/**
 * @file IOrgFreedesktopDbusObjectManagerCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief OrgFreedesktop DBUS Callback Interface for ObjectManager.
 *
 * @copyright (C) 2016 - 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for OrgFreedesktop DBUS callback for ObjectManager.
 */

#ifndef _I_ORG_FREEDESKTOP_DBUS_OBJECT_MANAGER_CALLBACK_IF_H_
#define _I_ORG_FREEDESKTOP_DBUS_OBJECT_MANAGER_CALLBACK_IF_H_

#include "CcDbusIfTypes.h"

#include "objmgr/org/freedesktop/DBus/ObjectManager.h"

using namespace ::objmgr::org::freedesktop::DBus::ObjectManager;

namespace ccdbusif {

/**
 * Callback interface class for ObjectManager.
 */
class IOrgFreedesktopDbusObjectManagerCallbackIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IOrgFreedesktopDbusObjectManagerCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   /**
    * Available signal.
    *
    * @param[in] available: available flag
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Unavailable signal.
    *
    * @param[in] available: available flag
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;
   // "ServiceAvailableIF" implementation --- end

   // objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- start
   /**
    * onGetManagedObjectsError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onGetManagedObjectsErrorCb(const ::boost::shared_ptr< GetManagedObjectsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onGetManagedObjectsResponse.
    *
    * @param[in] response: response signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onGetManagedObjectsResponseCb(const ::boost::shared_ptr< GetManagedObjectsResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onInterfacesAddedError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onInterfacesAddedErrorCb(const ::boost::shared_ptr< InterfacesAddedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onInterfacesAddedSignal.
    *
    * @param[in] signal: signal signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onInterfacesAddedSignalCb(const ::boost::shared_ptr< InterfacesAddedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onInterfacesRemovedError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onInterfacesRemovedErrorCb(const ::boost::shared_ptr< InterfacesRemovedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onInterfacesRemovedSignal.
    *
    * @param[in] signal: signal signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onInterfacesRemovedSignalCb(const ::boost::shared_ptr< InterfacesRemovedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;
   // objmgr/org/freedesktop/DBus/ObjectManagerProxy implementation --- end
};

} //ccdbusif

#endif //_I_ORG_FREEDESKTOP_DBUS_OBJECT_MANAGER_CALLBACK_IF_H_
