/**
 * @file IntrospectableProxyManager.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Proxy management for introspectable interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Proxy management for introspectable interface.
 */

#ifndef _INTROSPECTABLE_PROXY_MANAGER_H_
#define _INTROSPECTABLE_PROXY_MANAGER_H_

#include "ProxyManager.h"

#include "introspect/org/freedesktop/DBus/IntrospectableProxy.h"

using namespace ::introspect::org::freedesktop::DBus::Introspectable;

namespace ccdbusif {

// class forward declarations
class IIntrospectableDbusCallbackIf;

/**
 *
 */
class IntrospectableProxyManager :
   public ProxyManager< IntrospectableProxy >
{
public:
   IntrospectableProxyManager();
   IntrospectableProxyManager(const IntrospectableProxyManager& ref);
   IntrospectableProxyManager& operator=(const IntrospectableProxyManager& ref);
   bool operator==(const IntrospectableProxyManager& ref) const;
   bool operator!=(const IntrospectableProxyManager& ref) const;
   virtual ~IntrospectableProxyManager();

   void addCallbackIf(const ProxyMetaData& metaData, IIntrospectableDbusCallbackIf* callback);
   void addCallbackIf(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, IIntrospectableDbusCallbackIf* callback);
   void removeCallbackIf(const ProxyMetaData& metaData);
   void removeCallbackIf(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user);
   IIntrospectableDbusCallbackIf* getCallbackIf(const ProxyMetaData& metaData);
   IIntrospectableDbusCallbackIf* getCallbackIf(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user);
   void removeAllCallbackIfs(void);

private:
   ::std::map<ProxyMetaData, IIntrospectableDbusCallbackIf*> _proxyMetaData2CallbackIf;
};

} //ccdbusif

#endif //_INTROSPECTABLE_PROXY_MANAGER_H_
