/**
 * @file IntrospectableDestroyRuntimeProxyWorkItem.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Destroy proxy work item for introspectable interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Destroy proxy work item for introspectable interface.
 */

#ifndef _INTROSPECTABLE_DESTROY_RUNTIME_PROXY_ITEM_H_
#define _INTROSPECTABLE_DESTROY_RUNTIME_PROXY_ITEM_H_

#include "IWorkItem.h"
#include "CcDbusIfTypes.h"

namespace ccdbusif {

// class forward declarations
class IIntrospectableDestroyRuntimeProxy;

/**
 *
 */
class IntrospectableDestroyRuntimeProxyWorkItem : public IWorkItem
{
public:
   IntrospectableDestroyRuntimeProxyWorkItem(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, IIntrospectableDestroyRuntimeProxy* destroyer);
   virtual ~IntrospectableDestroyRuntimeProxyWorkItem();
   virtual void processWorkItem(void);

protected:
   IntrospectableDestroyRuntimeProxyWorkItem();

private:
   ::std::string _busName;
   ::std::string _objPath;
   DbusBusType _busType;
   void* _user;
   IIntrospectableDestroyRuntimeProxy* _proxyDestroyer;
};

} //ccdbusif

#endif //_INTROSPECTABLE_DESTROY_RUNTIME_PROXY_ITEM_H_
