/**
 * @file IntrospectableDbusProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Introspectable DBUS Proxy.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Introspectable DBUS Proxy.
 */

#ifndef _INTROSPECTABLE_DBUS_PROXY_IF_H_
#define _INTROSPECTABLE_DBUS_PROXY_IF_H_

#include "ICcDbusIfDestroyProxy.h"
#include "IIntrospectableCreateRuntimeProxy.h"
#include "IIntrospectableDestroyRuntimeProxy.h"
#include "IIntrospectableDbusSendRequestIf.h"
#include "IntrospectableProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "introspect/org/freedesktop/DBus/IntrospectableProxy.h"

using namespace ::introspect::org::freedesktop::DBus::Introspectable;

using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IIntrospectableDbusCallbackIf;

/**
 *
 */
class IntrospectableDbusProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfDestroyProxy,
   public IIntrospectableCreateRuntimeProxy,
   public IIntrospectableDestroyRuntimeProxy,
   public IIntrospectableDbusSendRequestIf,
   public BaseDbusProxyIf
{
public:
   IntrospectableDbusProxyIf(ICcDbusIfControllerClient* client);

   virtual ~IntrospectableDbusProxyIf();

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, IIntrospectableDbusCallbackIf* callbackIf);

   virtual void destroyRuntimeProxy(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user);

   virtual void setCallbackIf(IIntrospectableDbusCallbackIf* callbackIf, bool enableProxy, const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // HINT: following interfaces are called within context of thread started in CcDbusIfController.cpp ("CC_DBUS_IF_THD")

   // IIntrospectableDbusSendRequestIf implementation --- start
   virtual act_t sendIntrospectRequest(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user);
   // IIntrospectableDbusSendRequestIf implementation --- end

protected:
   IntrospectableDbusProxyIf();

private:
   IntrospectableProxyManager _proxy;
};

} //ccdbusif

#endif //_INTROSPECTABLE_DBUS_PROXY_IF_H_
