/**
 * @file IIntrospectableDbusSendRequestIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Introspectable DBUS Send Request Interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for Introspectable DBUS send requests.
 */

#ifndef _I_INTROSPECTABLE_DBUS_SEND_REQUEST_IF_H_
#define _I_INTROSPECTABLE_DBUS_SEND_REQUEST_IF_H_

#include "CcDbusIfTypes.h"

namespace ccdbusif {

// class forward declarations
class IIntrospectableDbusCallbackIf;

/**
 *
 */
class IIntrospectableDbusSendRequestIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IIntrospectableDbusSendRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableProxy: flag to enable/disable proxy
    * @param[in] busName: bus name
    * @param[in] objPath: object path
    * @param[in] busType: bus type
    * @param[in] user: user
    */
   virtual void setCallbackIf(IIntrospectableDbusCallbackIf* callbackIf, bool enableProxy, const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user) = 0;

   /**
    * Send method request to get introspection data.
    *
    * @param[in] busName: bus name
    * @param[in] objPath: object path
    * @param[in] busType: bus type
    * @param[in] user: user
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendIntrospectRequest(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user) = 0;
};

} //ccdbusif

#endif //_I_INTROSPECTABLE_DBUS_SEND_REQUEST_IF_H_
