/**
 * @file IIntrospectableDbusCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Introspectable DBUS Callback Interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for Introspectable DBUS callbacks.
 */

#ifndef _I_INTROSPECTABLE_DBUS_CALLBACK_IF_H_
#define _I_INTROSPECTABLE_DBUS_CALLBACK_IF_H_

#include "CcDbusIfTypes.h"

#include "introspect/org/freedesktop/DBus/IntrospectableProxy.h"

using namespace ::introspect::org::freedesktop::DBus::Introspectable;

using namespace ::asf::core;

namespace ccdbusif {

/**
 *
 */
class IIntrospectableDbusCallbackIf :
   // from IntrospectableProxy.h --- start
   public IntrospectCallbackIF
   // from IntrospectableProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IIntrospectableDbusCallbackIf() {}

   // HINT: these interfaces are called within context of thread defined in CcDbusIfAppLibrary.cma ("ccDbusIfThread")

   // "ServiceAvailableIF" implementation --- start
   virtual void onIntrospectableProxyAvailable(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, const ServiceState previousState, const ServiceState currentState) = 0;
   virtual void onIntrospectableProxyUnavailable(const ::std::string& busName, const ::std::string& objPath, const DbusBusType busType, void* user, const ServiceState previousState, const ServiceState currentState) = 0;
   // "ServiceAvailableIF" implementation --- end

   // Introspectable implementation --- start
   // HINT: proxy object delivers following data:
   //    const std::string& getDBusBusName() const;
   //    const std::string& getDBusObjectPath() const;
   //    const std::string& getInterfaceName() const;
   //    DbusBusType getBusType() const;
   virtual void onIntrospectError(const ::boost::shared_ptr< IntrospectableProxy >& proxy, const ::boost::shared_ptr< IntrospectError >& error) = 0;
   virtual void onIntrospectResponse(const ::boost::shared_ptr< IntrospectableProxy >& proxy, const ::boost::shared_ptr< IntrospectResponse >& response) = 0;
   // Introspectable implementation --- end
};

} //ccdbusif

#endif //_I_INTROSPECTABLE_DBUS_CALLBACK_IF_H_
