/**
 * @file EvolutionGeniviDbusTraceProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for Trace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Trace.
 */

#include "EvolutionGeniviDbusTraceProxyIf.h"
#include "IEvolutionGeniviDbusTraceCallbackIf.h"
#include "CcDbusIfTypes.h"
#include "ICcDbusIfControllerClient.h"
#include "CcDbusIfCreateProxyWorkItem.h"

#include "TraceClasses.h"
#define FW_S_IMPORT_INTERFACE_TRACE
#include "framework_if_if.h"

using namespace ::org::bluez::evo::Trace;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusTraceProxyIf.cpp.trc.h"
#endif
#endif

namespace ccdbusif {

EvolutionGeniviDbusTraceProxyIf::EvolutionGeniviDbusTraceProxyIf()
{
   // _traceProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusTraceProxyIf::EvolutionGeniviDbusTraceProxyIf(ICcDbusIfControllerClient* client) : BaseDbusProxyIf(client)
{
   // _traceProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusTraceProxyIf::~EvolutionGeniviDbusTraceProxyIf()
{
   _callbackIf = NULL;
}

void EvolutionGeniviDbusTraceProxyIf::createProxy(void)
{
   ETG_TRACE_USR3((" createProxy(): Trace"));

   if(NULL != _callbackIf)
   {
      if(true == _enableProxy)
      {
         _traceProxy = TraceProxy::createProxy("evoTracePort", *this);
      }
   }
}

void EvolutionGeniviDbusTraceProxyIf::destroyProxy(void)
{
   ETG_TRACE_USR3((" destroyProxy(): Trace"));

   if(NULL != _traceProxy.get())
   {
      _traceProxy->sendDeregisterAll();
      _traceProxy.reset();
   }
}

void EvolutionGeniviDbusTraceProxyIf::destroyAllRuntimeProxies(void)
{
   ETG_TRACE_USR3((" destroyAllRuntimeProxies(): Trace"));

   // nothing to do because this is a static proxy
}

void EvolutionGeniviDbusTraceProxyIf::setCallbackIf(IEvolutionGeniviDbusTraceCallbackIf* callbackIf, bool enableProxy)
{
   _callbackIf = callbackIf;

   if(NULL != _callbackIf)
   {
      _enableProxy = enableProxy;
   }

   // callback interface is now available => create proxy now
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfCreateProxyWorkItem(this));
   }
}

// ServiceAvailableIF implementation --- start
void EvolutionGeniviDbusTraceProxyIf::onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onAvailable(): Trace"));

   if((NULL != _traceProxy.get()) && (proxy == _traceProxy))
   {
      if(NULL != _callbackIf)
      {
         _traceProxy->sendReportDebugTraceRegister(*_callbackIf);
         _traceProxy->sendReportProtocolTraceRegister(*_callbackIf);
         _traceProxy->sendFatalErrorRegister(*_callbackIf);
         _traceProxy->sendGeneralErrorRegister(*_callbackIf);

         _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(), _traceProxy->getDBusObjectPath());
      }
   }
}

void EvolutionGeniviDbusTraceProxyIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onUnavailable(): Trace"));

   if((NULL != _traceProxy.get()) && (proxy == _traceProxy))
   {
      _traceProxy->sendDeregisterAll();

      if(NULL != _callbackIf)
      {
         _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(), _traceProxy->getDBusObjectPath());
      }
   }
}
// ServiceAvailableIF implementation --- end

// IEvolutionGeniviDbusTraceProxyIf implementation --- start
act_t EvolutionGeniviDbusTraceProxyIf::sendDebugTraceConfigRequest(uint8 level, uint32 current_time, uint8 mode, uint32 category1, uint32 category2, uint32 category3)
{
   if((NULL != _callbackIf) && (NULL != _traceProxy.get()))
   {
      return _traceProxy->sendDebugTraceConfigRequest(*_callbackIf, level, current_time, mode, category1, category2, category3);
   }
   else
   {
      return DEFAULT_ACT;
   }
}

act_t EvolutionGeniviDbusTraceProxyIf::sendProtocolTraceConfigRequest(uint16 filter)
{
   if((NULL != _callbackIf) && (NULL != _traceProxy.get()))
   {
      return _traceProxy->sendProtocolTraceConfigRequest(*_callbackIf, filter);
   }
   else
   {
      return DEFAULT_ACT;
   }
}
// IEvolutionGeniviDbusTraceProxyIf implementation --- end

} //ccdbusif
