/**
 * @file EvolutionGeniviDbusServiceFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for Service.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Service.
 */

#include "EvolutionGeniviDbusServiceFactory.h"
#include "EvolutionGeniviDbusServiceProxyIf.h"

namespace ccdbusif {

EvolutionGeniviDbusServiceFactory::EvolutionGeniviDbusServiceFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusServiceFactory::~EvolutionGeniviDbusServiceFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusServiceFactory& EvolutionGeniviDbusServiceFactory::getInstance(void)
{
   static EvolutionGeniviDbusServiceFactory factory;
   return factory;
}

IEvolutionGeniviDbusServiceSendRequestIf* EvolutionGeniviDbusServiceFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(NULL != _proxy)
   {
      // already created
   }
   else
   {
      EvolutionGeniviDbusServiceProxyIf* tmp = new EvolutionGeniviDbusServiceProxyIf(client);
      _proxy = tmp;
      _destroyer = tmp;
      _createdLocally = true;
   }

   return _proxy;
}

void EvolutionGeniviDbusServiceFactory::destroyProxy(void)
{
   if((NULL != _proxy) && (true == _createdLocally))
   {
      delete _proxy;
      _proxy = NULL;
      _destroyer = NULL;
   }
}

void EvolutionGeniviDbusServiceFactory::setProxyForTesting(IEvolutionGeniviDbusServiceSendRequestIf* testProxy)
{
   if(NULL != _proxy)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _proxy = testProxy;
      _destroyer = NULL;
      _createdLocally = false;
   }
}

} //ccdbusif
