/**
 * @file EvolutionGeniviDbusSerialProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for Serial.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for Serial.
 */

#include "EvolutionGeniviDbusSerialProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusSerialProperties::EvolutionGeniviDbusSerialProperties() :
DbusProperties("Serial"),
// properties
_propertyFlowCtrlRecv("FlowCtrlRecv")
{
   _string2EnumList[_propertyFlowCtrlRecv] = (int)SERIAL_FLOWCTRLRECV;

   _enum2StringList[(int)SERIAL_FLOWCTRLRECV] = &_propertyFlowCtrlRecv;
}

EvolutionGeniviDbusSerialProperties::~EvolutionGeniviDbusSerialProperties()
{
}

SerialProperty EvolutionGeniviDbusSerialProperties::getProperty2Enum(const ::std::string& value) const
{
   return (SerialProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusSerialProperties::getProperty2String(const SerialProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusSerialProperties::getProperty2StringTrace(const SerialProperty value) const
{
   if(SERIAL_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
