/**
 * @file EvolutionGeniviDbusSerialFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for Serial.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Serial.
 */

#include "EvolutionGeniviDbusSerialFactory.h"
#include "EvolutionGeniviDbusSerialProxyIf.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusSerialFactory::EvolutionGeniviDbusSerialFactory() :
_proxy(0),
_testProxy(0)
{
}

EvolutionGeniviDbusSerialFactory::~EvolutionGeniviDbusSerialFactory()
{
   _proxy = 0;
   _testProxy = 0;
}

EvolutionGeniviDbusSerialFactory& EvolutionGeniviDbusSerialFactory::getInstance(void)
{
   static EvolutionGeniviDbusSerialFactory factory;
   return factory;
}

IEvolutionGeniviDbusSerialSendRequestIf* EvolutionGeniviDbusSerialFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(0 != _proxy)
   {
      // already created
   }
   else
   {
      _proxy = new EvolutionGeniviDbusSerialProxyIf(client, _testProxy);
   }

   return _proxy;
}

void EvolutionGeniviDbusSerialFactory::destroyProxy(void)
{
   if(0 != _proxy)
   {
      delete _proxy;
      _proxy = 0;
   }
}

void EvolutionGeniviDbusSerialFactory::setProxyForTesting(IEvolutionGeniviDbusSerialTestProxyIf* testProxy)
{
   _testProxy = testProxy;
}

} //evolution
} //ccdbusif
