/**
 * @file EvolutionGeniviDbusParser.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Property Parser.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Property Parser.
 */

#include "EvolutionGeniviDbusParser.h"
#include "EvolutionGeniviDbusInterfaces.h"
#include "DbusParser.h"
#include "TraceClasses.h"
#include "FwAssert.h"
#include "FwTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusParser.cpp.trc.h"
#endif
#endif

namespace ccdbusif {
namespace evolution {

static EvolutionGeniviDbusInterfaces dbusInterfaces;
static DbusParser dbusParser;

EvolutionGeniviDbusParser::EvolutionGeniviDbusParser()
{
   _tracesEnabled = false;
   dbusParser.setTraces(_tracesEnabled);
}

EvolutionGeniviDbusParser::~EvolutionGeniviDbusParser()
{
}

void EvolutionGeniviDbusParser::parseProperties(::std::vector<DbusVariantProperty>& outProperties, const ::std::vector< int >& matchingInterfaces, ::std::map< ::std::string, ::asf::dbus::DBusVariant >& inProperties,
      const DbusBusType busType, const ::std::string& busName, const ::std::string& objPath, const ::std::string& interfaceName) const
{
   dbusParser.parseProperties(outProperties, matchingInterfaces, inProperties, busType, busName, objPath, interfaceName, &dbusInterfaces);
}

void EvolutionGeniviDbusParser::parseIntrospection(const ::std::string& data,
      const DbusBusType busType, const ::std::string& busName, const ::std::string& objPath, const ::std::string& interfaceName) const
{
   dbusParser.parseIntrospection(data, busType, busName, objPath, interfaceName, &dbusInterfaces);
}

void EvolutionGeniviDbusParser::parseInterfacesAdded(const ::std::string& addedObjectPath, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& inInterfaces,
      const DbusBusType busType, const ::std::string& busName, const ::std::string& objPath, const ::std::string& interfaceName) const
{
   dbusParser.parseInterfacesAdded(addedObjectPath, inInterfaces, busType, busName, objPath, interfaceName, &dbusInterfaces);
}

void EvolutionGeniviDbusParser::parseInterfacesRemoved(const ::std::string& removedObjectPath, const ::std::vector< ::std::string >& inInterfaces,
      const DbusBusType busType, const ::std::string& busName, const ::std::string& objPath, const ::std::string& interfaceName) const
{
   dbusParser.parseInterfacesRemoved(removedObjectPath, inInterfaces, busType, busName, objPath, interfaceName, &dbusInterfaces);
}

bool EvolutionGeniviDbusParser::findAndParseProperty(::std::vector<DbusVariantProperty>& outPropertyList, ::std::map< ::std::string, ::asf::dbus::DBusVariant >& inProperties, const ::std::string& propertyName, const int interface) const
{
   return dbusParser.findAndParseProperty(outPropertyList, inProperties, propertyName, interface, &dbusInterfaces);
}

void EvolutionGeniviDbusParser::parseProperty(::std::vector<DbusVariantProperty>& outPropertyList, ::asf::dbus::DBusVariant& propertyValue, const ::std::string& propertyName, const int interface) const
{
   dbusParser.parsePropertyValue(outPropertyList, propertyValue, propertyName, interface, &dbusInterfaces);
}

void EvolutionGeniviDbusParser::addDictionaryItem(::std::map< ::std::string, ::asf::dbus::DBusVariant >& dictionary, const ::std::string& key, const DbusVariant& value) const
{
   dbusParser.addDictionaryItem(dictionary, key, value);
}

void EvolutionGeniviDbusParser::addVariantValue(::asf::dbus::DBusVariant& item, const DbusVariant& value) const
{
   dbusParser.addVariantValue(item, value);
}

ServiceState EvolutionGeniviDbusParser::convertString2ServiceState(const ::std::string& value) const
{
   return dbusInterfaces.convertString2ServiceState(value);
}

AdapterProperty EvolutionGeniviDbusParser::getAdapterProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getAdapterProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getAdapterProperty2String(const AdapterProperty value) const
{
   return dbusInterfaces.getAdapterProperty2String(value);
}

AgentManagerCapabilitySuppValues EvolutionGeniviDbusParser::getAgentManagerCapability2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getAgentManagerCapability2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getAgentManagerCapability2String(const AgentManagerCapabilitySuppValues value) const
{
   return dbusInterfaces.getAgentManagerCapability2String(value);
}

DeviceProperty EvolutionGeniviDbusParser::getDeviceProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getDeviceProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getDeviceProperty2String(const DeviceProperty value) const
{
   return dbusInterfaces.getDeviceProperty2String(value);
}

ServiceProperty EvolutionGeniviDbusParser::getServiceProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getServiceProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getServiceProperty2String(const ServiceProperty value) const
{
   return dbusInterfaces.getServiceProperty2String(value);
}

HfpHandsfreeProperty EvolutionGeniviDbusParser::getHfpHandsfreeProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getHfpHandsfreeProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getHfpHandsfreeProperty2String(const HfpHandsfreeProperty value) const
{
   return dbusInterfaces.getHfpHandsfreeProperty2String(value);
}

const ::std::map< std::string, int >& EvolutionGeniviDbusParser::getHfpHandsfreeFeatures2EnumList(void) const
{
   return dbusInterfaces.getHfpHandsfreeFeatures2EnumList();
}

const ::std::map< std::string, int >* EvolutionGeniviDbusParser::getHfpHandsfreeFeatures2EnumListPtr(void) const
{
   return dbusInterfaces.getHfpHandsfreeFeatures2EnumListPtr();
}

const ::std::map< int, const std::string* >& EvolutionGeniviDbusParser::getHfpHandsfreeFeatures2StringList(void) const
{
   return dbusInterfaces.getHfpHandsfreeFeatures2StringList();
}

const ::std::map< int, const std::string* >* EvolutionGeniviDbusParser::getHfpHandsfreeFeatures2StringListPtr(void) const
{
   return dbusInterfaces.getHfpHandsfreeFeatures2StringListPtr();
}

HfpHandsfreeFeatures EvolutionGeniviDbusParser::getHfpHandsfreeFeatures2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getHfpHandsfreeFeatures2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getHfpHandsfreeFeatures2String(const HfpHandsfreeFeatures value) const
{
   return dbusInterfaces.getHfpHandsfreeFeatures2String(value);
}

HfpHandsfreeChldFeatureSuppValues EvolutionGeniviDbusParser::getHfpHandsfreeChldFeature2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getHfpHandsfreeChldFeature2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getHfpHandsfreeChldFeature2String(const HfpHandsfreeChldFeatureSuppValues value) const
{
   return dbusInterfaces.getHfpHandsfreeChldFeature2String(value);
}

HfpCallVolumeProperty EvolutionGeniviDbusParser::getHfpCallVolumeProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getHfpCallVolumeProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getHfpCallVolumeProperty2String(const HfpCallVolumeProperty value) const
{
   return dbusInterfaces.getHfpCallVolumeProperty2String(value);
}

HfpModemProperty EvolutionGeniviDbusParser::getHfpModemProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getHfpModemProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getHfpModemProperty2String(const HfpModemProperty value) const
{
   return dbusInterfaces.getHfpModemProperty2String(value);
}

inline HfpModemInterfaces EvolutionGeniviDbusParser::getHfpModemInterface2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getHfpModemInterface2Enum(value);
}

inline const ::std::string& EvolutionGeniviDbusParser::getHfpModemInterface2String(const HfpModemInterfaces value) const
{
   return dbusInterfaces.getHfpModemInterface2String(value);
}

inline HfpModemTypeSuppValues EvolutionGeniviDbusParser::getHfpModemType2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getHfpModemType2Enum(value);
}

inline const ::std::string& EvolutionGeniviDbusParser::getHfpModemType2String(const HfpModemTypeSuppValues value) const
{
   return dbusInterfaces.getHfpModemType2String(value);
}

HfpNetworkOperatorProperty EvolutionGeniviDbusParser::getHfpNetworkOperatorProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getHfpNetworkOperatorProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getHfpNetworkOperatorProperty2String(const HfpNetworkOperatorProperty value) const
{
   return dbusInterfaces.getHfpNetworkOperatorProperty2String(value);
}

HfpNetworkRegistrationProperty EvolutionGeniviDbusParser::getHfpNetworkRegistrationProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getHfpNetworkRegistrationProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getHfpNetworkRegistrationProperty2String(const HfpNetworkRegistrationProperty value) const
{
   return dbusInterfaces.getHfpNetworkRegistrationProperty2String(value);
}

HfpSiriProperty EvolutionGeniviDbusParser::getHfpSiriProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getHfpSiriProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getHfpSiriProperty2String(const HfpSiriProperty value) const
{
   return dbusInterfaces.getHfpSiriProperty2String(value);
}

HfpVoiceCallManagerProperty EvolutionGeniviDbusParser::getHfpVoiceCallManagerProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getHfpVoiceCallManagerProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getHfpVoiceCallManagerProperty2String(const HfpVoiceCallManagerProperty value) const
{
   return dbusInterfaces.getHfpVoiceCallManagerProperty2String(value);
}

HfpVoiceCallProperty EvolutionGeniviDbusParser::getHfpVoiceCallProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getHfpVoiceCallProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getHfpVoiceCallProperty2String(const HfpVoiceCallProperty value) const
{
   return dbusInterfaces.getHfpVoiceCallProperty2String(value);
}

ObexSessionProperty EvolutionGeniviDbusParser::getObexSessionProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getObexSessionProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getObexSessionProperty2String(const ObexSessionProperty value) const
{
   return dbusInterfaces.getObexSessionProperty2String(value);
}

ObexClientArgsSuppValues EvolutionGeniviDbusParser::getObexClientType2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getObexClientType2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getObexClientType2String(const ObexClientArgsSuppValues value) const
{
   return dbusInterfaces.getObexClientType2String(value);
}

ObexTransferProperty EvolutionGeniviDbusParser::getObexTransferProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getObexTransferProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getObexTransferProperty2String(const ObexTransferProperty value) const
{
   return dbusInterfaces.getObexTransferProperty2String(value);
}

SerialProperty EvolutionGeniviDbusParser::getSerialProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getSerialProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getSerialProperty2String(const SerialProperty value) const
{
   return dbusInterfaces.getSerialProperty2String(value);
}

LEAdapterProperty EvolutionGeniviDbusParser::getLEAdapterProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getLEAdapterProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getLEAdapterProperty2String(const LEAdapterProperty value) const
{
   return dbusInterfaces.getLEAdapterProperty2String(value);
}

LEDeviceProperty EvolutionGeniviDbusParser::getLEDeviceProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getLEDeviceProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getLEDeviceProperty2String(const LEDeviceProperty value) const
{
   return dbusInterfaces.getLEDeviceProperty2String(value);
}

LESeamlessPairingProperty EvolutionGeniviDbusParser::getLESeamlessPairingProperty2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getLESeamlessPairingProperty2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getLESeamlessPairingProperty2String(const LESeamlessPairingProperty value) const
{
   return dbusInterfaces.getLESeamlessPairingProperty2String(value);
}

UUID EvolutionGeniviDbusParser::getUuid2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getUuid2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getUuid2String(const UUID value) const
{
   return dbusInterfaces.getUuid2String(value);
}

const ::std::string& EvolutionGeniviDbusParser::getUuid2StringTrace(const UUID value) const
{
   return dbusInterfaces.getUuid2StringTrace(value);
}

bool EvolutionGeniviDbusParser::isValidUuid(const ::std::string& value, const bool ignoreCaseSensitive /*= true*/) const
{
   return dbusInterfaces.isValidUuid(value, ignoreCaseSensitive);
}

bool EvolutionGeniviDbusParser::isShortUuid(UUID& uuid, const ::std::string& value) const
{
   return dbusInterfaces.isShortUuid(uuid, value);
}

Interface EvolutionGeniviDbusParser::getInterface2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getInterface2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getInterface2String(const Interface value) const
{
   return dbusInterfaces.getInterface2String(value);
}

const ::std::string& EvolutionGeniviDbusParser::getInterface2StringTrace(const Interface value) const
{
   return dbusInterfaces.getInterface2StringTrace(value);
}

DbusBusType EvolutionGeniviDbusParser::getInterface2BusType(const Interface value) const
{
   return dbusInterfaces.getInterface2BusType(value);
}

DbusBusType EvolutionGeniviDbusParser::getBusType(const Interface value) const
{
   return dbusInterfaces.getInterface2BusType(value);
}

const ::std::string& EvolutionGeniviDbusParser::getInterface2BusName(const Interface value) const
{
   return dbusInterfaces.getInterface2BusName(value);
}

const ::std::string& EvolutionGeniviDbusParser::getBusName(const Interface value) const
{
   return dbusInterfaces.getInterface2BusName(value);
}

const ::std::string& EvolutionGeniviDbusParser::getInterface2ObjectPath(const Interface value) const
{
   return dbusInterfaces.getInterface2ObjectPath(value);
}

const ::std::string& EvolutionGeniviDbusParser::getObjectPath(const Interface value) const
{
   return dbusInterfaces.getInterface2ObjectPath(value);
}

const ::std::string& EvolutionGeniviDbusParser::getRootObjectPath(void) const
{
   return dbusInterfaces.getRootObjectPath();
}

const ::std::string& EvolutionGeniviDbusParser::getInterface2Port(const Interface value) const
{
   return dbusInterfaces.getInterface2Port(value);
}

const ::std::string& EvolutionGeniviDbusParser::getPort(const Interface value) const
{
   return dbusInterfaces.getInterface2Port(value);
}

DbusBusType EvolutionGeniviDbusParser::getAgentBusType(void) const
{
   return dbusInterfaces.getAgentBusType();
}

const ::std::string& EvolutionGeniviDbusParser::getAgentBusName(void) const
{
   return dbusInterfaces.getAgentBusName();
}

const ::std::string& EvolutionGeniviDbusParser::getAgentObjectPath(void) const
{
   return dbusInterfaces.getAgentObjectPath();
}

ErrorCode EvolutionGeniviDbusParser::getErrorCode2Enum(const ::std::string& value) const
{
   return dbusInterfaces.getErrorCode2Enum(value);
}

const ::std::string& EvolutionGeniviDbusParser::getErrorCode2String(const ErrorCode value) const
{
   return dbusInterfaces.getErrorCode2String(value);
}

const ::std::string& EvolutionGeniviDbusParser::getErrorCode2StringTrace(const ErrorCode value) const
{
   return dbusInterfaces.getErrorCode2StringTrace(value);
}

ErrorCode EvolutionGeniviDbusParser::getErrorCode2Enum(const ::std::string& errorName, const ::std::string& errorMessage) const
{
   return dbusInterfaces.getErrorCode2Enum(errorName, errorMessage);
}

void EvolutionGeniviDbusParser::setTraces(const bool enabled)
{
   _tracesEnabled = enabled;
   dbusParser.setTraces(_tracesEnabled);
}

} //evolution
} //ccdbusif
