/**
 * @file EvolutionGeniviDbusObexClientProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for ObexClient.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for ObexClient.
 */

#include "EvolutionGeniviDbusObexClientProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusObexClientProperties::EvolutionGeniviDbusObexClientProperties() : DbusProperties("Client"),
   _argsMap("MAP"),
   _argsPbap("PBAP"),
   _argsTarget("Target"),
   _argsSource("Source"),
   _argsChannel("Channel"),
   _argsInstanceID("InstanceID")
{
   _args2EnumList[_argsMap] = (int)OBEX_CLIENT_ARGS_MAP;
   _args2EnumList[_argsPbap] = (int)OBEX_CLIENT_ARGS_PBAP;
   _args2EnumList[_argsTarget] = (int)OBEX_CLIENT_ARGS_TARGET;
   _args2EnumList[_argsSource] = (int)OBEX_CLIENT_ARGS_SOURCE;
   _args2EnumList[_argsChannel] = (int)OBEX_CLIENT_ARGS_CHANNEL;
   _args2EnumList[_argsInstanceID] = (int)OBEX_CLIENT_ARGS_INSTANCE_ID;

   _enum2ArgsList[(int)OBEX_CLIENT_ARGS_MAP] = &_argsMap;
   _enum2ArgsList[(int)OBEX_CLIENT_ARGS_PBAP] = &_argsPbap;
   _enum2ArgsList[(int)OBEX_CLIENT_ARGS_TARGET] = &_argsTarget;
   _enum2ArgsList[(int)OBEX_CLIENT_ARGS_SOURCE] = &_argsSource;
   _enum2ArgsList[(int)OBEX_CLIENT_ARGS_CHANNEL] = &_argsChannel;
   _enum2ArgsList[(int)OBEX_CLIENT_ARGS_INSTANCE_ID] = &_argsInstanceID;
}

EvolutionGeniviDbusObexClientProperties::~EvolutionGeniviDbusObexClientProperties()
{
   _args2EnumList.clear();
   _enum2ArgsList.clear();
}

ObexClientArgsSuppValues EvolutionGeniviDbusObexClientProperties::getType2Enum(const ::std::string& value) const
{
   return (ObexClientArgsSuppValues)convertString2Enum(_args2EnumList, value);
}

const ::std::string& EvolutionGeniviDbusObexClientProperties::getType2String(const ObexClientArgsSuppValues value) const
{
   if(OBEX_CLIENT_ARGS_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String(_enum2ArgsList, (const int)value, false);
   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
