/**
 * @file EvolutionGeniviDbusLESeamlessPairingProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS proxy for LESeamlessPairing.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for LESeamlessPairing.
 */

#include "EvolutionGeniviDbusLESeamlessPairingProxyIf.h"
#include "IEvolutionGeniviDbusLESeamlessPairingCallbackIf.h"
#include "CcDbusIfTypes.h"
#include "CcDbusIfUtils.h"
#include "ICcDbusIfControllerClient.h"
#include "CcDbusIfCreateProxyWorkItem.h"
#include "CcDbusIfCreateRuntimeProxyWorkItem.h"
#include "CcDbusIfDestroyRuntimeProxyWorkItem.h"
#include "EvolutionGeniviDbusParser.h"

#include "TraceClasses.h"
#define FW_S_IMPORT_INTERFACE_TRACE
#include "framework_if_if.h"

using namespace ::org::bluez::SeamlessPairing;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusLESeamlessPairingProxyIf.cpp.trc.h"
#endif
#endif

namespace ccdbusif {

EvolutionGeniviDbusLESeamlessPairingProxyIf::EvolutionGeniviDbusLESeamlessPairingProxyIf()
{
   // _lESeamlessPairingProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusLESeamlessPairingProxyIf::EvolutionGeniviDbusLESeamlessPairingProxyIf(ICcDbusIfControllerClient* client) : BaseDbusProxyIf(client)
{
   // _lESeamlessPairingProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusLESeamlessPairingProxyIf::~EvolutionGeniviDbusLESeamlessPairingProxyIf()
{
   _callbackIf = NULL;
}

void EvolutionGeniviDbusLESeamlessPairingProxyIf::createProxy(void)
{
   // these proxies have to be created during runtime
}

void EvolutionGeniviDbusLESeamlessPairingProxyIf::destroyProxy(void)
{
   ETG_TRACE_USR3((" destroyProxy(): SeamlessPairing"));

   // these proxies have to be destroyed during runtime
   // destroy all proxies now if still available
   _lESeamlessPairingProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusLESeamlessPairingProxyIf::destroyAllRuntimeProxies(void)
{
   ETG_TRACE_USR3((" destroyAllRuntimeProxies(): SeamlessPairing"));

   for(unsigned int i = 0; i < _lESeamlessPairingProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< SeamlessPairingProxy >& lESeamlessPairingProxy = _lESeamlessPairingProxy[i];
      if(NULL != lESeamlessPairingProxy.get())
      {
         lESeamlessPairingProxy->sendDeregisterAll();
      }
   }

   _lESeamlessPairingProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusLESeamlessPairingProxyIf::createRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3((" createRuntimeProxy(): SeamlessPairing: objPath=%s", objPath.c_str()));

   if((NULL != _callbackIf) && (true == _enableProxy))
   {
      if(false == _lESeamlessPairingProxy.isInstanceAvailable(objPath))
      {
         evolution::EvolutionGeniviDbusParser parser;
         ::boost::shared_ptr< SeamlessPairingProxy > lESeamlessPairingProxy = SeamlessPairingProxy::createProxy("evoLESeamlessPairingPort", parser.getInterface2BusName(evolution::IF_LE_SEAMLESS_PAIRING), objPath, convertLocalBusType(parser.getInterface2BusType(evolution::IF_LE_SEAMLESS_PAIRING)), *this);
         _lESeamlessPairingProxy.addProxyInstance(objPath, lESeamlessPairingProxy);
      }
   }
}

void EvolutionGeniviDbusLESeamlessPairingProxyIf::destroyRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3((" destroyRuntimeProxy(): SeamlessPairing: objPath=%s", objPath.c_str()));

   // HINT: destroying runtime proxy is not possible because ASF is storing a proxy "reference" internally; therefore reset() call will not causing destruction of proxy
   // HINT: due to this we explicitly have to call sendDeregisterAll() to force removing of signal registration (DBUS: member=RemoveMatch)
   // HINT: sendDeregisterAll() is automatically called during destruction of proxy

   ::boost::shared_ptr< SeamlessPairingProxy > lESeamlessPairingProxy;
   if(true == _lESeamlessPairingProxy.isProxyAvailable(lESeamlessPairingProxy, objPath))
   {
      lESeamlessPairingProxy->sendDeregisterAll();
   }
   _lESeamlessPairingProxy.removeProxyInstance(objPath);
}

void EvolutionGeniviDbusLESeamlessPairingProxyIf::setCallbackIf(IEvolutionGeniviDbusLESeamlessPairingCallbackIf* callbackIf, bool enableProxy)
{
   _callbackIf = callbackIf;

   if(NULL != _callbackIf)
   {
      _enableProxy = enableProxy;
   }

   // callback interface is now available => but proxy will be created later
}

void EvolutionGeniviDbusLESeamlessPairingProxyIf::seamlessPairingCreated(const ::std::string& objPath)
{
   // create runtime proxy
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfCreateRuntimeProxyWorkItem(objPath, this));
   }
}

void EvolutionGeniviDbusLESeamlessPairingProxyIf::seamlessPairingRemoved(const ::std::string& objPath)
{
   // destroy runtime proxy
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfDestroyRuntimeProxyWorkItem(objPath, this));
   }
}

// ServiceAvailableIF implementation --- start
void EvolutionGeniviDbusLESeamlessPairingProxyIf::onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onAvailable(): SeamlessPairing"));

   for(unsigned int i = 0; i < _lESeamlessPairingProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< SeamlessPairingProxy >& lESeamlessPairingProxy = _lESeamlessPairingProxy[i];
      if((NULL != lESeamlessPairingProxy.get()) && (proxy == lESeamlessPairingProxy))
      {
         if(NULL != _callbackIf)
         {
            lESeamlessPairingProxy->sendErrorCodeReceivedRegister(*_callbackIf);
            lESeamlessPairingProxy->sendAccessRequestRegister(*_callbackIf);
            lESeamlessPairingProxy->sendPairingDataRegister(*_callbackIf);

            _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(), lESeamlessPairingProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

void EvolutionGeniviDbusLESeamlessPairingProxyIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onUnavailable(): SeamlessPairing"));

   for(unsigned int i = 0; i < _lESeamlessPairingProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< SeamlessPairingProxy >& lESeamlessPairingProxy = _lESeamlessPairingProxy[i];
      if((NULL != lESeamlessPairingProxy.get()) && (proxy == lESeamlessPairingProxy))
      {
         lESeamlessPairingProxy->sendDeregisterAll();

         if(NULL != _callbackIf)
         {
            _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(), lESeamlessPairingProxy->getDBusObjectPath());
         }
         break;
      }
   }
}
// ServiceAvailableIF implementation --- end

// IEvolutionGeniviDbusLESeamlessPairingProxyIf implementation --- start
act_t EvolutionGeniviDbusLESeamlessPairingProxyIf::sendSendErrorCodeRequest(const ::std::string& objPath, const ::std::string& error_code)
{
   ::boost::shared_ptr< SeamlessPairingProxy > proxy;
   if(true == _lESeamlessPairingProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendSendErrorCodeRequest(*_callbackIf, error_code);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusLESeamlessPairingProxyIf::sendAllowAccessRequest(const ::std::string& objPath, bool accept)
{
   ::boost::shared_ptr< SeamlessPairingProxy > proxy;
   if(true == _lESeamlessPairingProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendAllowAccessRequest(*_callbackIf, accept);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusLESeamlessPairingProxyIf::sendPairingDataGet(const ::std::string& objPath)
{
   ::boost::shared_ptr< SeamlessPairingProxy > proxy;
   if(true == _lESeamlessPairingProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendPairingDataGet(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

void EvolutionGeniviDbusLESeamlessPairingProxyIf::sendPairingDataSet(const ::std::string& objPath, const ::std::vector< uint8 >& pairingData)
{
   ::boost::shared_ptr< SeamlessPairingProxy > proxy;
   if(true == _lESeamlessPairingProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         proxy->sendPairingDataSet(pairingData);
      }
   }
}
// IEvolutionGeniviDbusLESeamlessPairingProxyIf implementation --- end

} //ccdbusif
