/**
 * @file EvolutionGeniviDbusLESeamlessPairingProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for LESeamlessPairing.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for LESeamlessPairing.
 */

#include "EvolutionGeniviDbusLESeamlessPairingProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusLESeamlessPairingProperties::EvolutionGeniviDbusLESeamlessPairingProperties() : DbusProperties("SeamlessPairing"),
   // properties
   _propertyPairingData("PairingData")
{
   _string2EnumList[_propertyPairingData] = (int)LE_SEAMLESS_PAIRING_PAIRINGDATA;

   _enum2StringList[(int)LE_SEAMLESS_PAIRING_PAIRINGDATA] = &_propertyPairingData;
}

EvolutionGeniviDbusLESeamlessPairingProperties::~EvolutionGeniviDbusLESeamlessPairingProperties()
{
}

LESeamlessPairingProperty EvolutionGeniviDbusLESeamlessPairingProperties::getProperty2Enum(const ::std::string& value) const
{
   return (LESeamlessPairingProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusLESeamlessPairingProperties::getProperty2String(const LESeamlessPairingProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusLESeamlessPairingProperties::getProperty2StringTrace(const LESeamlessPairingProperty value) const
{
   if(LE_SEAMLESS_PAIRING_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
