/**
 * @file EvolutionGeniviDbusLEDeviceProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for LEDevice.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for LEDevice.
 */

#include "EvolutionGeniviDbusLEDeviceProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusLEDeviceProperties::EvolutionGeniviDbusLEDeviceProperties() : DbusProperties("LEDevice1"),
   // properties
   _propertyAddressType("AddressType"),
   _propertyAddress("Address"),
   _propertyConnected("Connected")
{
   _string2EnumList[_propertyAddressType] = (int)LE_DEVICE_ADDRESSTYPE;
   _string2EnumList[_propertyAddress] = (int)LE_DEVICE_ADDRESS;
   _string2EnumList[_propertyConnected] = (int)LE_DEVICE_CONNECTED;

   _enum2StringList[(int)LE_DEVICE_ADDRESSTYPE] = &_propertyAddressType;
   _enum2StringList[(int)LE_DEVICE_ADDRESS] = &_propertyAddress;
   _enum2StringList[(int)LE_DEVICE_CONNECTED] = &_propertyConnected;
}

EvolutionGeniviDbusLEDeviceProperties::~EvolutionGeniviDbusLEDeviceProperties()
{
}

LEDeviceProperty EvolutionGeniviDbusLEDeviceProperties::getProperty2Enum(const ::std::string& value) const
{
   return (LEDeviceProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusLEDeviceProperties::getProperty2String(const LEDeviceProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusLEDeviceProperties::getProperty2StringTrace(const LEDeviceProperty value) const
{
   if(LE_DEVICE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
