/**
 * @file EvolutionGeniviDbusHfpVoiceCallManagerProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpVoiceCallManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpVoiceCallManager.
 */

#include "EvolutionGeniviDbusHfpVoiceCallManagerProxyIf.h"
#include "IEvolutionGeniviDbusHfpVoiceCallManagerCallbackIf.h"
#include "CcDbusIfTypes.h"
#include "CcDbusIfUtils.h"
#include "ICcDbusIfControllerClient.h"
#include "CcDbusIfCreateProxyWorkItem.h"
#include "CcDbusIfCreateRuntimeProxyWorkItem.h"
#include "CcDbusIfDestroyRuntimeProxyWorkItem.h"
#include "EvolutionGeniviDbusParser.h"

#include "TraceClasses.h"
#define FW_S_IMPORT_INTERFACE_TRACE
#include "framework_if_if.h"

using namespace ::org::ofono::VoiceCallManager;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpVoiceCallManagerProxyIf.cpp.trc.h"
#endif
#endif

namespace ccdbusif {

EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::EvolutionGeniviDbusHfpVoiceCallManagerProxyIf()
{
   // _hfpVoiceCallManagerProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::EvolutionGeniviDbusHfpVoiceCallManagerProxyIf(ICcDbusIfControllerClient* client) : BaseDbusProxyIf(client)
{
   // _hfpVoiceCallManagerProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::~EvolutionGeniviDbusHfpVoiceCallManagerProxyIf()
{
   _callbackIf = NULL;
}

void EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::createProxy(void)
{
   // these proxies have to be created during runtime
}

void EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::destroyProxy(void)
{
   ETG_TRACE_USR3((" destroyProxy(): VoiceCallManager"));

   // these proxies have to be destroyed during runtime
   // destroy all proxies now if still available
   _hfpVoiceCallManagerProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::destroyAllRuntimeProxies(void)
{
   ETG_TRACE_USR3((" destroyAllRuntimeProxies(): VoiceCallManager"));

   for(unsigned int i = 0; i < _hfpVoiceCallManagerProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< VoiceCallManagerProxy >& hfpVoiceCallManagerProxy = _hfpVoiceCallManagerProxy[i];
      if(NULL != hfpVoiceCallManagerProxy.get())
      {
         hfpVoiceCallManagerProxy->sendDeregisterAll();
      }
   }

   _hfpVoiceCallManagerProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::createRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3((" createRuntimeProxy(): VoiceCallManager: objPath=%s", objPath.c_str()));

   if((NULL != _callbackIf) && (true == _enableProxy))
   {
      if(false == _hfpVoiceCallManagerProxy.isInstanceAvailable(objPath))
      {
         evolution::EvolutionGeniviDbusParser parser;
         ::boost::shared_ptr< VoiceCallManagerProxy > hfpVoiceCallManagerProxy = VoiceCallManagerProxy::createProxy("evoHfpVoiceCallManagerPort", parser.getInterface2BusName(evolution::IF_VOICE_CALL_MANAGER), objPath, convertLocalBusType(parser.getInterface2BusType(evolution::IF_VOICE_CALL_MANAGER)), *this);
         _hfpVoiceCallManagerProxy.addProxyInstance(objPath, hfpVoiceCallManagerProxy);
      }
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::destroyRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3((" destroyRuntimeProxy(): VoiceCallManager: objPath=%s", objPath.c_str()));

   // HINT: destroying runtime proxy is not possible because ASF is storing a proxy "reference" internally; therefore reset() call will not causing destruction of proxy
   // HINT: due to this we explicitly have to call sendDeregisterAll() to force removing of signal registration (DBUS: member=RemoveMatch)
   // HINT: sendDeregisterAll() is automatically called during destruction of proxy

   ::boost::shared_ptr< VoiceCallManagerProxy > hfpVoiceCallManagerProxy;
   if(true == _hfpVoiceCallManagerProxy.isProxyAvailable(hfpVoiceCallManagerProxy, objPath))
   {
      hfpVoiceCallManagerProxy->sendDeregisterAll();
   }
   _hfpVoiceCallManagerProxy.removeProxyInstance(objPath);
}

void EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::setCallbackIf(IEvolutionGeniviDbusHfpVoiceCallManagerCallbackIf* callbackIf, bool enableProxy)
{
   _callbackIf = callbackIf;

   if(NULL != _callbackIf)
   {
      _enableProxy = enableProxy;
   }

   // callback interface is now available => but proxy will be created later
}

void EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::deviceCreated(const ::std::string& objPath)
{
   // create runtime proxy
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfCreateRuntimeProxyWorkItem(objPath, this));
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::deviceRemoved(const ::std::string& objPath)
{
   // destroy runtime proxy
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfDestroyRuntimeProxyWorkItem(objPath, this));
   }
}

// ServiceAvailableIF implementation --- start
void EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onAvailable(): VoiceCallManager"));

   for(unsigned int i = 0; i < _hfpVoiceCallManagerProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< VoiceCallManagerProxy >& hfpVoiceCallManagerProxy = _hfpVoiceCallManagerProxy[i];
      if((NULL != hfpVoiceCallManagerProxy.get()) && (proxy == hfpVoiceCallManagerProxy))
      {
         if(NULL != _callbackIf)
         {
            hfpVoiceCallManagerProxy->sendCallAddedRegister(*_callbackIf);
            hfpVoiceCallManagerProxy->sendCallRemovedRegister(*_callbackIf);
            hfpVoiceCallManagerProxy->sendPropertyChangedRegister(*_callbackIf);

            _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(), hfpVoiceCallManagerProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onUnavailable(): VoiceCallManager"));

   for(unsigned int i = 0; i < _hfpVoiceCallManagerProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< VoiceCallManagerProxy >& hfpVoiceCallManagerProxy = _hfpVoiceCallManagerProxy[i];
      if((NULL != hfpVoiceCallManagerProxy.get()) && (proxy == hfpVoiceCallManagerProxy))
      {
         hfpVoiceCallManagerProxy->sendDeregisterAll();

         if(NULL != _callbackIf)
         {
            _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(), hfpVoiceCallManagerProxy->getDBusObjectPath());
         }
         break;
      }
   }
}
// ServiceAvailableIF implementation --- end

// IEvolutionGeniviDbusHfpVoiceCallManagerProxyIf implementation --- start
act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendGetPropertiesRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendGetPropertiesRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendGetCallsRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendGetCallsRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendDialRequest(const ::std::string& objPath, const ::std::string& number, const ::std::string& hide_callerid)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendDialRequest(*_callbackIf, number, hide_callerid);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendMemDialRequest(const ::std::string& objPath, uint16 numberindex, const ::std::string& hide_callerid)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendMemDialRequest(*_callbackIf, numberindex, hide_callerid);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendRedialRequest(const ::std::string& objPath, const ::std::string& hide_callerid)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendRedialRequest(*_callbackIf, hide_callerid);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendSwapCallsRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendSwapCallsRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendReleaseAndAnswerRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendReleaseAndAnswerRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendReleaseAndSwapRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendReleaseAndSwapRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendHoldAndAnswerRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendHoldAndAnswerRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendHangupAllRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendHangupAllRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendPrivateChatRequest(const ::std::string& objPath, const ::std::string& call)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendPrivateChatRequest(*_callbackIf, call);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendCreateMultipartyRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendCreateMultipartyRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendHangupMultipartyRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendHangupMultipartyRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpVoiceCallManagerProxyIf::sendSendTonesRequest(const ::std::string& objPath, const ::std::string& sendTones)
{
   ::boost::shared_ptr< VoiceCallManagerProxy > proxy;
   if(true == _hfpVoiceCallManagerProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendSendTonesRequest(*_callbackIf, sendTones);
      }
   }
   return DEFAULT_ACT;
}
// IEvolutionGeniviDbusHfpVoiceCallManagerProxyIf implementation --- end

} //ccdbusif
