/**
 * @file EvolutionGeniviDbusHfpVoiceCallManagerProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for HfpVoiceCallManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for HfpVoiceCallManager.
 */

#include "EvolutionGeniviDbusHfpVoiceCallManagerProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusHfpVoiceCallManagerProperties::EvolutionGeniviDbusHfpVoiceCallManagerProperties() : DbusProperties("VoiceCallManager"),
   // properties
   _propertyEmergencyNumbers("EmergencyNumbers")
{
   _string2EnumList[_propertyEmergencyNumbers] = (int)HFP_VOICE_CALL_MANAGER_EMERGENCYNUMBERS;

   _enum2StringList[(int)HFP_VOICE_CALL_MANAGER_EMERGENCYNUMBERS] = &_propertyEmergencyNumbers;
}

EvolutionGeniviDbusHfpVoiceCallManagerProperties::~EvolutionGeniviDbusHfpVoiceCallManagerProperties()
{
}

HfpVoiceCallManagerProperty EvolutionGeniviDbusHfpVoiceCallManagerProperties::getProperty2Enum(const ::std::string& value) const
{
   return (HfpVoiceCallManagerProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusHfpVoiceCallManagerProperties::getProperty2String(const HfpVoiceCallManagerProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusHfpVoiceCallManagerProperties::getProperty2StringTrace(const HfpVoiceCallManagerProperty value) const
{
   if(HFP_VOICE_CALL_MANAGER_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
