/**
 * @file EvolutionGeniviDbusHfpSiriFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for HfpSiri.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for HfpSiri.
 */

#include "EvolutionGeniviDbusHfpSiriFactory.h"
#include "EvolutionGeniviDbusHfpSiriProxyIf.h"

namespace ccdbusif {

EvolutionGeniviDbusHfpSiriFactory::EvolutionGeniviDbusHfpSiriFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusHfpSiriFactory::~EvolutionGeniviDbusHfpSiriFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusHfpSiriFactory& EvolutionGeniviDbusHfpSiriFactory::getInstance(void)
{
   static EvolutionGeniviDbusHfpSiriFactory factory;
   return factory;
}

IEvolutionGeniviDbusHfpSiriSendRequestIf* EvolutionGeniviDbusHfpSiriFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(NULL != _proxy)
   {
      // already created
   }
   else
   {
      EvolutionGeniviDbusHfpSiriProxyIf* tmp = new EvolutionGeniviDbusHfpSiriProxyIf(client);
      _proxy = tmp;
      _destroyer = tmp;
      _createdLocally = true;
   }

   return _proxy;
}

void EvolutionGeniviDbusHfpSiriFactory::destroyProxy(void)
{
   if((NULL != _proxy) && (true == _createdLocally))
   {
      delete _proxy;
      _proxy = NULL;
      _destroyer = NULL;
   }
}

void EvolutionGeniviDbusHfpSiriFactory::setProxyForTesting(IEvolutionGeniviDbusHfpSiriSendRequestIf* testProxy)
{
   if(NULL != _proxy)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _proxy = testProxy;
      _destroyer = NULL;
      _createdLocally = false;
   }
}

} //ccdbusif
