/**
 * @file EvolutionGeniviDbusHfpManagerProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpManager.
 */

#include "EvolutionGeniviDbusHfpManagerProxyIf.h"
#include "IEvolutionGeniviDbusHfpManagerCallbackIf.h"
#include "CcDbusIfTypes.h"
#include "ICcDbusIfControllerClient.h"
#include "CcDbusIfCreateProxyWorkItem.h"

#include "TraceClasses.h"
#define FW_S_IMPORT_INTERFACE_TRACE
#include "framework_if_if.h"

using namespace ::org::ofono::Manager;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpManagerProxyIf.cpp.trc.h"
#endif
#endif

namespace ccdbusif {

EvolutionGeniviDbusHfpManagerProxyIf::EvolutionGeniviDbusHfpManagerProxyIf()
{
   // _hfpManagerProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusHfpManagerProxyIf::EvolutionGeniviDbusHfpManagerProxyIf(ICcDbusIfControllerClient* client) : BaseDbusProxyIf(client)
{
   // _hfpManagerProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusHfpManagerProxyIf::~EvolutionGeniviDbusHfpManagerProxyIf()
{
   _callbackIf = NULL;
}

void EvolutionGeniviDbusHfpManagerProxyIf::createProxy(void)
{
   ETG_TRACE_USR3((" createProxy(): Manager"));

   if(NULL != _callbackIf)
   {
      if(true == _enableProxy)
      {
         _hfpManagerProxy = ManagerProxy::createProxy("evoHfpManagerPort", *this);
      }
   }
}

void EvolutionGeniviDbusHfpManagerProxyIf::destroyProxy(void)
{
   ETG_TRACE_USR3((" destroyProxy(): Manager"));

   if(NULL != _hfpManagerProxy.get())
   {
      _hfpManagerProxy->sendDeregisterAll();
      _hfpManagerProxy.reset();
   }
}

void EvolutionGeniviDbusHfpManagerProxyIf::destroyAllRuntimeProxies(void)
{
   ETG_TRACE_USR3((" destroyAllRuntimeProxies(): Manager"));

   // nothing to do because this is a static proxy
}

void EvolutionGeniviDbusHfpManagerProxyIf::setCallbackIf(IEvolutionGeniviDbusHfpManagerCallbackIf* callbackIf, bool enableProxy)
{
   _callbackIf = callbackIf;

   if(NULL != _callbackIf)
   {
      _enableProxy = enableProxy;
   }

   // callback interface is now available => create proxy now
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfCreateProxyWorkItem(this));
   }
}

// ServiceAvailableIF implementation --- start
void EvolutionGeniviDbusHfpManagerProxyIf::onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onAvailable(): Manager"));

   if((NULL != _hfpManagerProxy.get()) && (proxy == _hfpManagerProxy))
   {
      if(NULL != _callbackIf)
      {
         _hfpManagerProxy->sendModemAddedRegister(*_callbackIf);
         _hfpManagerProxy->sendModemRemovedRegister(*_callbackIf);

         _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(), _hfpManagerProxy->getDBusObjectPath());
      }
   }
}

void EvolutionGeniviDbusHfpManagerProxyIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onUnavailable(): Manager"));

   if((NULL != _hfpManagerProxy.get()) && (proxy == _hfpManagerProxy))
   {
      _hfpManagerProxy->sendDeregisterAll();

      if(NULL != _callbackIf)
      {
         _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(), _hfpManagerProxy->getDBusObjectPath());
      }
   }
}
// ServiceAvailableIF implementation --- end

// IEvolutionGeniviDbusHfpManagerProxyIf implementation --- start
act_t EvolutionGeniviDbusHfpManagerProxyIf::sendGetModemsRequest(void)
{
   if((NULL != _callbackIf) && (NULL != _hfpManagerProxy.get()))
   {
      return _hfpManagerProxy->sendGetModemsRequest(*_callbackIf);
   }
   else
   {
      return DEFAULT_ACT;
   }
}
// IEvolutionGeniviDbusHfpManagerProxyIf implementation --- end

} //ccdbusif
