/**
 * @file EvolutionGeniviDbusHfpManagerFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for HfpManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for HfpManager.
 */

#include "EvolutionGeniviDbusHfpManagerFactory.h"
#include "EvolutionGeniviDbusHfpManagerProxyIf.h"

namespace ccdbusif {

EvolutionGeniviDbusHfpManagerFactory::EvolutionGeniviDbusHfpManagerFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusHfpManagerFactory::~EvolutionGeniviDbusHfpManagerFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusHfpManagerFactory& EvolutionGeniviDbusHfpManagerFactory::getInstance(void)
{
   static EvolutionGeniviDbusHfpManagerFactory factory;
   return factory;
}

IEvolutionGeniviDbusHfpManagerSendRequestIf* EvolutionGeniviDbusHfpManagerFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(NULL != _proxy)
   {
      // already created
   }
   else
   {
      EvolutionGeniviDbusHfpManagerProxyIf* tmp = new EvolutionGeniviDbusHfpManagerProxyIf(client);
      _proxy = tmp;
      _destroyer = tmp;
      _createdLocally = true;
   }

   return _proxy;
}

void EvolutionGeniviDbusHfpManagerFactory::destroyProxy(void)
{
   if((NULL != _proxy) && (true == _createdLocally))
   {
      delete _proxy;
      _proxy = NULL;
      _destroyer = NULL;
   }
}

void EvolutionGeniviDbusHfpManagerFactory::setProxyForTesting(IEvolutionGeniviDbusHfpManagerSendRequestIf* testProxy)
{
   if(NULL != _proxy)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _proxy = testProxy;
      _destroyer = NULL;
      _createdLocally = false;
   }
}

} //ccdbusif
