/**
 * @file EvolutionGeniviDbusHfpHandsfreeProxyIf.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpHandsfree.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpHandsfree.
 */

#include "EvolutionGeniviDbusHfpHandsfreeProxyIf.h"
#include "IEvolutionGeniviDbusHfpHandsfreeCallbackIf.h"
#include "CcDbusIfTypes.h"
#include "CcDbusIfUtils.h"
#include "ICcDbusIfControllerClient.h"
#include "CcDbusIfCreateProxyWorkItem.h"
#include "CcDbusIfCreateRuntimeProxyWorkItem.h"
#include "CcDbusIfDestroyRuntimeProxyWorkItem.h"
#include "EvolutionGeniviDbusParser.h"

#include "TraceClasses.h"
#define FW_S_IMPORT_INTERFACE_TRACE
#include "framework_if_if.h"

using namespace ::org::ofono::Handsfree;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCDBUSIF_COMMON
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpHandsfreeProxyIf.cpp.trc.h"
#endif
#endif

namespace ccdbusif {

EvolutionGeniviDbusHfpHandsfreeProxyIf::EvolutionGeniviDbusHfpHandsfreeProxyIf()
{
   // _hfpHandsfreeProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusHfpHandsfreeProxyIf::EvolutionGeniviDbusHfpHandsfreeProxyIf(ICcDbusIfControllerClient* client) : BaseDbusProxyIf(client)
{
   // _hfpHandsfreeProxy is set later
   _callbackIf = NULL;
}

EvolutionGeniviDbusHfpHandsfreeProxyIf::~EvolutionGeniviDbusHfpHandsfreeProxyIf()
{
   _callbackIf = NULL;
}

void EvolutionGeniviDbusHfpHandsfreeProxyIf::createProxy(void)
{
   // these proxies have to be created during runtime
}

void EvolutionGeniviDbusHfpHandsfreeProxyIf::destroyProxy(void)
{
   ETG_TRACE_USR3((" destroyProxy(): Handsfree"));

   // these proxies have to be destroyed during runtime
   // destroy all proxies now if still available
   _hfpHandsfreeProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusHfpHandsfreeProxyIf::destroyAllRuntimeProxies(void)
{
   ETG_TRACE_USR3((" destroyAllRuntimeProxies(): Handsfree"));

   for(unsigned int i = 0; i < _hfpHandsfreeProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< HandsfreeProxy >& hfpHandsfreeProxy = _hfpHandsfreeProxy[i];
      if(NULL != hfpHandsfreeProxy.get())
      {
         hfpHandsfreeProxy->sendDeregisterAll();
      }
   }

   _hfpHandsfreeProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusHfpHandsfreeProxyIf::createRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3((" createRuntimeProxy(): Handsfree: objPath=%s", objPath.c_str()));

   if((NULL != _callbackIf) && (true == _enableProxy))
   {
      if(false == _hfpHandsfreeProxy.isInstanceAvailable(objPath))
      {
         evolution::EvolutionGeniviDbusParser parser;
         ::boost::shared_ptr< HandsfreeProxy > hfpHandsfreeProxy = HandsfreeProxy::createProxy("evoHfpHandsfreePort", parser.getInterface2BusName(evolution::IF_HANDSFREE), objPath, convertLocalBusType(parser.getInterface2BusType(evolution::IF_HANDSFREE)), *this);
         _hfpHandsfreeProxy.addProxyInstance(objPath, hfpHandsfreeProxy);
      }
   }
}

void EvolutionGeniviDbusHfpHandsfreeProxyIf::destroyRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3((" destroyRuntimeProxy(): Handsfree: objPath=%s", objPath.c_str()));

   // HINT: destroying runtime proxy is not possible because ASF is storing a proxy "reference" internally; therefore reset() call will not causing destruction of proxy
   // HINT: due to this we explicitly have to call sendDeregisterAll() to force removing of signal registration (DBUS: member=RemoveMatch)
   // HINT: sendDeregisterAll() is automatically called during destruction of proxy

   ::boost::shared_ptr< HandsfreeProxy > hfpHandsfreeProxy;
   if(true == _hfpHandsfreeProxy.isProxyAvailable(hfpHandsfreeProxy, objPath))
   {
      hfpHandsfreeProxy->sendDeregisterAll();
   }
   _hfpHandsfreeProxy.removeProxyInstance(objPath);
}

void EvolutionGeniviDbusHfpHandsfreeProxyIf::setCallbackIf(IEvolutionGeniviDbusHfpHandsfreeCallbackIf* callbackIf, bool enableProxy)
{
   _callbackIf = callbackIf;

   if(NULL != _callbackIf)
   {
      _enableProxy = enableProxy;
   }

   // callback interface is now available => but proxy will be created later
}

void EvolutionGeniviDbusHfpHandsfreeProxyIf::deviceCreated(const ::std::string& objPath)
{
   // create runtime proxy
   if((NULL != _callbackIf) && (NULL != _controllerClient))
   {
      _controllerClient->pushWorkItem(new CcDbusIfCreateRuntimeProxyWorkItem(objPath, this));
   }
}

void EvolutionGeniviDbusHfpHandsfreeProxyIf::deviceRemoved(const ::std::string& objPath, const bool destroyDirectly /*= false*/)
{
   // destroy runtime proxy
   if (true == destroyDirectly)
   {
      // Called within context of ASF component thread, we can directly destroy the proxy.
      destroyRuntimeProxy(objPath);
   }
   else
   {
      if ((NULL != _callbackIf) && (NULL != _controllerClient))
      {
         _controllerClient->pushWorkItem(new CcDbusIfDestroyRuntimeProxyWorkItem(objPath, this));
      }
   }
}

// ServiceAvailableIF implementation --- start
void EvolutionGeniviDbusHfpHandsfreeProxyIf::onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onAvailable(): Handsfree"));

   for(unsigned int i = 0; i < _hfpHandsfreeProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< HandsfreeProxy >& hfpHandsfreeProxy = _hfpHandsfreeProxy[i];
      if((NULL != hfpHandsfreeProxy.get()) && (proxy == hfpHandsfreeProxy))
      {
         if(NULL != _callbackIf)
         {
            hfpHandsfreeProxy->sendPropertyChangedRegister(*_callbackIf);
            hfpHandsfreeProxy->sendRecvATCommandRegister(*_callbackIf);

            _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(), hfpHandsfreeProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

void EvolutionGeniviDbusHfpHandsfreeProxyIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3((" onUnavailable(): Handsfree"));

   for(unsigned int i = 0; i < _hfpHandsfreeProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< HandsfreeProxy >& hfpHandsfreeProxy = _hfpHandsfreeProxy[i];
      if((NULL != hfpHandsfreeProxy.get()) && (proxy == hfpHandsfreeProxy))
      {
         hfpHandsfreeProxy->sendDeregisterAll();

         if(NULL != _callbackIf)
         {
            _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(), hfpHandsfreeProxy->getDBusObjectPath());
         }
         break;
      }
   }
}
// ServiceAvailableIF implementation --- end

// IEvolutionGeniviDbusHfpHandsfreeProxyIf implementation --- start
act_t EvolutionGeniviDbusHfpHandsfreeProxyIf::sendGetPropertiesRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< HandsfreeProxy > proxy;
   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendGetPropertiesRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpHandsfreeProxyIf::sendSetPropertyRequest(const ::std::string& objPath, const ::std::string& property, const bool value)
{
   ::boost::shared_ptr< HandsfreeProxy > proxy;
   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         ::asf::dbus::DBusVariant variant;
         DbusVariant vValue;
         vValue.setBool(value);
         evolution::EvolutionGeniviDbusParser parser;
         parser.addVariantValue(variant, vValue);
         return proxy->sendSetPropertyRequest(*_callbackIf, property, variant);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpHandsfreeProxyIf::sendSetPropertyRequest(const ::std::string& objPath, const ::std::string& property, const ::std::string& value)
{
   ::boost::shared_ptr< HandsfreeProxy > proxy;
   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         ::asf::dbus::DBusVariant variant;
         DbusVariant vValue;
         vValue.setString(value);
         evolution::EvolutionGeniviDbusParser parser;
         parser.addVariantValue(variant, vValue);
         return proxy->sendSetPropertyRequest(*_callbackIf, property, variant);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpHandsfreeProxyIf::sendRequestPhoneNumberRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< HandsfreeProxy > proxy;
   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendRequestPhoneNumberRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpHandsfreeProxyIf::sendGetSubscriberRequest(const ::std::string& objPath)
{
   ::boost::shared_ptr< HandsfreeProxy > proxy;
   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendGetSubscriberRequest(*_callbackIf);
      }
   }
   return DEFAULT_ACT;
}

act_t EvolutionGeniviDbusHfpHandsfreeProxyIf::sendSendCustomATCommandRequest(const ::std::string& objPath, const ::std::vector< uint8 >& data)
{
   ::boost::shared_ptr< HandsfreeProxy > proxy;
   if(true == _hfpHandsfreeProxy.isInstanceAvailable(proxy, objPath))
   {
      if((NULL != _callbackIf) && (NULL != proxy.get()))
      {
         return proxy->sendSendCustomATCommandRequest(*_callbackIf, data);
      }
   }
   return DEFAULT_ACT;
}
// IEvolutionGeniviDbusHfpHandsfreeProxyIf implementation --- end

} //ccdbusif
