/**
 * @file EvolutionGeniviDbusHfpHandsfreeProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for HfpHandsfree.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for HfpHandsfree.
 */

#include "EvolutionGeniviDbusHfpHandsfreeProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusHfpHandsfreeProperties::EvolutionGeniviDbusHfpHandsfreeProperties() : DbusProperties("Handsfree"),
   // properties
   _propertyFeatures("Features"),
   _propertyInbandRinging("InbandRinging"),
   _propertyVoiceRecognition("VoiceRecognition"),
   _propertyEchoCancelingNoiseReduction("EchoCancelingNoiseReduction"),
   _propertyBatteryChargeLevel("BatteryChargeLevel"),
   _propertyAudio("Audio"),
   _propertySCOType("SCOType"),
   _propertyAudioPath("AudioPath"),
   _propertyAllCallStatus("AllCallStatus"),
   _propertyChldFeature("ChldFeature"),
   _propertyAudioIndicator("AudioIndicator"),

   // supported values for Features
   _featuresVoice_recognition("Voice-recognition"),
   _featuresAttach_voice_tag("Attach-voice-tag"),
   _features3way("3way"),
   _featuresECNR("ECNR"),
   _featuresInband_ring("Inband_ring"),
   _featuresReject_incoming_call("Reject_incoming_call"),
   _featuresEnhanced_call_status("Enhanced_call_status"),
   _featuresEnhanced_call_control("Enhanced_call_control"),
   _featuresExtended_error_codes("Extended_error_codes"),
   _featuresCodec_negotiation("Codec_negotiation"),
   _featuresHF_indicators("HF indicators"),
   _featureseSCO_S4_and_T2_Setting_supported("eSCO S4(and T2) Setting supported"),

   // supported values for ChldFeature
   _chldFeature_0("CHLD=0"),
   _chldFeature_1("CHLD=1"),
   _chldFeature_1x("CHLD=1x"),
   _chldFeature_2("CHLD=2"),
   _chldFeature_2x("CHLD=2x"),
   _chldFeature_3("CHLD=3"),
   _chldFeature_4("CHLD=4")
{
   _string2EnumList[_propertyFeatures] = (int)HFP_HANDSFREE_FEATURES;
   _string2EnumList[_propertyInbandRinging] = (int)HFP_HANDSFREE_INBANDRINGING;
   _string2EnumList[_propertyVoiceRecognition] = (int)HFP_HANDSFREE_VOICERECOGNITION;
   _string2EnumList[_propertyEchoCancelingNoiseReduction] = (int)HFP_HANDSFREE_ECHOCANCELINGNOISEREDUCTION;
   _string2EnumList[_propertyBatteryChargeLevel] = (int)HFP_HANDSFREE_BATTERYCHARGELEVEL;
   _string2EnumList[_propertyAudio] = (int)HFP_HANDSFREE_AUDIO;
   _string2EnumList[_propertySCOType] = (int)HFP_HANDSFREE_SCOTYPE;
   _string2EnumList[_propertyAudioPath] = (int)HFP_HANDSFREE_AUDIOPATH;
   _string2EnumList[_propertyAllCallStatus] = (int)HFP_HANDSFREE_ALLCALLSTATUS;
   _string2EnumList[_propertyChldFeature] = (int)HFP_HANDSFREE_CHLDFEATURE;
   _string2EnumList[_propertyAudioIndicator] = (int)HFP_HANDSFREE_AUDIOINDICATOR;

   _enum2StringList[(int)HFP_HANDSFREE_FEATURES] = &_propertyFeatures;
   _enum2StringList[(int)HFP_HANDSFREE_INBANDRINGING] = &_propertyInbandRinging;
   _enum2StringList[(int)HFP_HANDSFREE_VOICERECOGNITION] = &_propertyVoiceRecognition;
   _enum2StringList[(int)HFP_HANDSFREE_ECHOCANCELINGNOISEREDUCTION] = &_propertyEchoCancelingNoiseReduction;
   _enum2StringList[(int)HFP_HANDSFREE_BATTERYCHARGELEVEL] = &_propertyBatteryChargeLevel;
   _enum2StringList[(int)HFP_HANDSFREE_AUDIO] = &_propertyAudio;
   _enum2StringList[(int)HFP_HANDSFREE_SCOTYPE] = &_propertySCOType;
   _enum2StringList[(int)HFP_HANDSFREE_AUDIOPATH] = &_propertyAudioPath;
   _enum2StringList[(int)HFP_HANDSFREE_ALLCALLSTATUS] = &_propertyAllCallStatus;
   _enum2StringList[(int)HFP_HANDSFREE_CHLDFEATURE] = &_propertyChldFeature;
   _enum2StringList[(int)HFP_HANDSFREE_AUDIOINDICATOR] = &_propertyAudioIndicator;

   _features2EnumList[_featuresVoice_recognition] = (int)HFP_HANDSFREE_FEATURES_VOICE_RECOGNITION;
   _features2EnumList[_featuresAttach_voice_tag] = (int)HFP_HANDSFREE_FEATURES_ATTACH_VOICE_TAG;
   _features2EnumList[_features3way] = (int)HFP_HANDSFREE_FEATURES_3WAY;
   _features2EnumList[_featuresECNR] = (int)HFP_HANDSFREE_FEATURES_ECNR;
   _features2EnumList[_featuresInband_ring] = (int)HFP_HANDSFREE_FEATURES_INBAND_RING;
   _features2EnumList[_featuresReject_incoming_call] = (int)HFP_HANDSFREE_FEATURES_REJECT_INCOMING_CALL;
   _features2EnumList[_featuresEnhanced_call_status] = (int)HFP_HANDSFREE_FEATURES_ENHANCED_CALL_STATUS;
   _features2EnumList[_featuresEnhanced_call_control] = (int)HFP_HANDSFREE_FEATURES_ENHANCED_CALL_CONTROL;
   _features2EnumList[_featuresExtended_error_codes] = (int)HFP_HANDSFREE_FEATURES_EXTENDED_ERROR_CODES;
   _features2EnumList[_featuresCodec_negotiation] = (int)HFP_HANDSFREE_FEATURES_CODEC_NEGOTIATION;
   _features2EnumList[_featuresHF_indicators] = (int)HFP_HANDSFREE_FEATURES_HF_INDICATORS;
   _features2EnumList[_featureseSCO_S4_and_T2_Setting_supported] = (int)HFP_HANDSFREE_FEATURES_ESCO_S4_AND_T2_SETTING_SUPPORTED;

   _enum2FeaturesList[(int)HFP_HANDSFREE_FEATURES_VOICE_RECOGNITION] = &_featuresVoice_recognition;
   _enum2FeaturesList[(int)HFP_HANDSFREE_FEATURES_ATTACH_VOICE_TAG] = &_featuresAttach_voice_tag;
   _enum2FeaturesList[(int)HFP_HANDSFREE_FEATURES_3WAY] = &_features3way;
   _enum2FeaturesList[(int)HFP_HANDSFREE_FEATURES_ECNR] = &_featuresECNR;
   _enum2FeaturesList[(int)HFP_HANDSFREE_FEATURES_INBAND_RING] = &_featuresInband_ring;
   _enum2FeaturesList[(int)HFP_HANDSFREE_FEATURES_REJECT_INCOMING_CALL] = &_featuresReject_incoming_call;
   _enum2FeaturesList[(int)HFP_HANDSFREE_FEATURES_ENHANCED_CALL_STATUS] = &_featuresEnhanced_call_status;
   _enum2FeaturesList[(int)HFP_HANDSFREE_FEATURES_ENHANCED_CALL_CONTROL] = &_featuresEnhanced_call_control;
   _enum2FeaturesList[(int)HFP_HANDSFREE_FEATURES_EXTENDED_ERROR_CODES] = &_featuresExtended_error_codes;
   _enum2FeaturesList[(int)HFP_HANDSFREE_FEATURES_CODEC_NEGOTIATION] = &_featuresCodec_negotiation;
   _enum2FeaturesList[(int)HFP_HANDSFREE_FEATURES_HF_INDICATORS] = &_featuresHF_indicators;
   _enum2FeaturesList[(int)HFP_HANDSFREE_FEATURES_ESCO_S4_AND_T2_SETTING_SUPPORTED] = &_featureseSCO_S4_and_T2_Setting_supported;

   _chldFeature2EnumList[_chldFeature_0] = (int)HFP_HANDSFREE_CHLD_FEATURE_0;
   _chldFeature2EnumList[_chldFeature_1] = (int)HFP_HANDSFREE_CHLD_FEATURE_1;
   _chldFeature2EnumList[_chldFeature_1x] = (int)HFP_HANDSFREE_CHLD_FEATURE_1X;
   _chldFeature2EnumList[_chldFeature_2] = (int)HFP_HANDSFREE_CHLD_FEATURE_2;
   _chldFeature2EnumList[_chldFeature_2x] = (int)HFP_HANDSFREE_CHLD_FEATURE_2X;
   _chldFeature2EnumList[_chldFeature_3] = (int)HFP_HANDSFREE_CHLD_FEATURE_3;
   _chldFeature2EnumList[_chldFeature_4] = (int)HFP_HANDSFREE_CHLD_FEATURE_4;

   _enum2ChldFeatureList[(int)HFP_HANDSFREE_CHLD_FEATURE_0] = &_chldFeature_0;
   _enum2ChldFeatureList[(int)HFP_HANDSFREE_CHLD_FEATURE_1] = &_chldFeature_1;
   _enum2ChldFeatureList[(int)HFP_HANDSFREE_CHLD_FEATURE_1X] = &_chldFeature_1x;
   _enum2ChldFeatureList[(int)HFP_HANDSFREE_CHLD_FEATURE_2] = &_chldFeature_2;
   _enum2ChldFeatureList[(int)HFP_HANDSFREE_CHLD_FEATURE_2X] = &_chldFeature_2x;
   _enum2ChldFeatureList[(int)HFP_HANDSFREE_CHLD_FEATURE_3] = &_chldFeature_3;
   _enum2ChldFeatureList[(int)HFP_HANDSFREE_CHLD_FEATURE_4] = &_chldFeature_4;
}

EvolutionGeniviDbusHfpHandsfreeProperties::~EvolutionGeniviDbusHfpHandsfreeProperties()
{
   _features2EnumList.clear();
   _enum2FeaturesList.clear();

   _chldFeature2EnumList.clear();
   _enum2ChldFeatureList.clear();
}

HfpHandsfreeProperty EvolutionGeniviDbusHfpHandsfreeProperties::getProperty2Enum(const ::std::string& value) const
{
   return (HfpHandsfreeProperty)convertString2Enum(value);
}

HfpHandsfreeFeatures EvolutionGeniviDbusHfpHandsfreeProperties::getFeatures2Enum(const ::std::string& value) const
{
   return (HfpHandsfreeFeatures)convertString2Enum(_features2EnumList, value);
}

HfpHandsfreeChldFeatureSuppValues EvolutionGeniviDbusHfpHandsfreeProperties::getChldFeature2Enum(const ::std::string& value) const
{
   return (HfpHandsfreeChldFeatureSuppValues)convertString2Enum(_chldFeature2EnumList, value);
}

const ::std::string& EvolutionGeniviDbusHfpHandsfreeProperties::getProperty2String(const HfpHandsfreeProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusHfpHandsfreeProperties::getProperty2StringTrace(const HfpHandsfreeProperty value) const
{
   if(HFP_HANDSFREE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

const ::std::string& EvolutionGeniviDbusHfpHandsfreeProperties::getFeatures2String(const HfpHandsfreeFeatures value) const
{
   return convertEnum2String(_enum2FeaturesList, (const int)value);
}

const ::std::string& EvolutionGeniviDbusHfpHandsfreeProperties::getFeatures2StringTrace(const HfpHandsfreeFeatures value) const
{
   if(HFP_HANDSFREE_FEATURES_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String(_enum2FeaturesList, (const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

const ::std::string& EvolutionGeniviDbusHfpHandsfreeProperties::getChldFeature2String(const HfpHandsfreeChldFeatureSuppValues value) const
{
   if(HFP_HANDSFREE_CHLD_FEATURE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String(_enum2ChldFeatureList, (const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
