/**
 * @file EvolutionGeniviDbusHfpCallVolumeProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for HfpCallVolume.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for HfpCallVolume.
 */

#include "EvolutionGeniviDbusHfpCallVolumeProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusHfpCallVolumeProperties::EvolutionGeniviDbusHfpCallVolumeProperties() : DbusProperties("CallVolume"),
   // properties
   _propertySpeakerVolume("SpeakerVolume"),
   _propertyMicrophoneVolume("MicrophoneVolume")
{
   _string2EnumList[_propertySpeakerVolume] = (int)HFP_CALL_VOLUME_SPEAKERVOLUME;
   _string2EnumList[_propertyMicrophoneVolume] = (int)HFP_CALL_VOLUME_MICROPHONEVOLUME;

   _enum2StringList[(int)HFP_CALL_VOLUME_SPEAKERVOLUME] = &_propertySpeakerVolume;
   _enum2StringList[(int)HFP_CALL_VOLUME_MICROPHONEVOLUME] = &_propertyMicrophoneVolume;
}

EvolutionGeniviDbusHfpCallVolumeProperties::~EvolutionGeniviDbusHfpCallVolumeProperties()
{
}

HfpCallVolumeProperty EvolutionGeniviDbusHfpCallVolumeProperties::getProperty2Enum(const ::std::string& value) const
{
   return (HfpCallVolumeProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusHfpCallVolumeProperties::getProperty2String(const HfpCallVolumeProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusHfpCallVolumeProperties::getProperty2StringTrace(const HfpCallVolumeProperty value) const
{
   if(HFP_CALL_VOLUME_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
