/**
 * @file EvolutionGeniviDbusGeniviTraceFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for GeniviTrace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for GeniviTrace.
 */

#include "EvolutionGeniviDbusGeniviTraceFactory.h"
#include "EvolutionGeniviDbusGeniviTraceProxyIf.h"

namespace ccdbusif {

EvolutionGeniviDbusGeniviTraceFactory::EvolutionGeniviDbusGeniviTraceFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusGeniviTraceFactory::~EvolutionGeniviDbusGeniviTraceFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusGeniviTraceFactory& EvolutionGeniviDbusGeniviTraceFactory::getInstance(void)
{
   static EvolutionGeniviDbusGeniviTraceFactory factory;
   return factory;
}

IEvolutionGeniviDbusGeniviTraceSendRequestIf* EvolutionGeniviDbusGeniviTraceFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(NULL != _proxy)
   {
      // already created
   }
   else
   {
      EvolutionGeniviDbusGeniviTraceProxyIf* tmp = new EvolutionGeniviDbusGeniviTraceProxyIf(client);
      _proxy = tmp;
      _destroyer = tmp;
      _createdLocally = true;
   }

   return _proxy;
}

void EvolutionGeniviDbusGeniviTraceFactory::destroyProxy(void)
{
   if((NULL != _proxy) && (true == _createdLocally))
   {
      delete _proxy;
      _proxy = NULL;
      _destroyer = NULL;
   }
}

void EvolutionGeniviDbusGeniviTraceFactory::setProxyForTesting(IEvolutionGeniviDbusGeniviTraceSendRequestIf* testProxy)
{
   if(NULL != _proxy)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _proxy = testProxy;
      _destroyer = NULL;
      _createdLocally = false;
   }
}

} //ccdbusif
