/**
 * @file EvolutionGeniviDbusDunFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for Dun.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Dun.
 */

#include "EvolutionGeniviDbusDunFactory.h"
#include "EvolutionGeniviDbusDunProxyIf.h"

namespace ccdbusif {

EvolutionGeniviDbusDunFactory::EvolutionGeniviDbusDunFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusDunFactory::~EvolutionGeniviDbusDunFactory()
{
   _proxy = NULL;
}

EvolutionGeniviDbusDunFactory& EvolutionGeniviDbusDunFactory::getInstance(void)
{
   static EvolutionGeniviDbusDunFactory factory;
   return factory;
}

IEvolutionGeniviDbusDunSendRequestIf* EvolutionGeniviDbusDunFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(NULL != _proxy)
   {
      // already created
   }
   else
   {
      EvolutionGeniviDbusDunProxyIf* tmp = new EvolutionGeniviDbusDunProxyIf(client);
      _proxy = tmp;
      _destroyer = tmp;
      _createdLocally = true;
   }

   return _proxy;
}

void EvolutionGeniviDbusDunFactory::destroyProxy(void)
{
   if((NULL != _proxy) && (true == _createdLocally))
   {
      delete _proxy;
      _proxy = NULL;
      _destroyer = NULL;
   }
}

void EvolutionGeniviDbusDunFactory::setProxyForTesting(IEvolutionGeniviDbusDunSendRequestIf* testProxy)
{
   if(NULL != _proxy)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _proxy = testProxy;
      _destroyer = NULL;
      _createdLocally = false;
   }
}

} //ccdbusif
