/**
 * @file EvolutionGeniviDbusDeviceProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for Device.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for Device.
 */

#include "EvolutionGeniviDbusDeviceProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusDeviceProperties::EvolutionGeniviDbusDeviceProperties() : DbusProperties("Device1"),
   // properties
   _propertyAddress("Address"),
   _propertyClass("Class"),
   _propertyIcon("Icon"),
   _propertyUUIDs("UUIDs"),
   _propertyPaired("Paired"),
   _propertyConnected("Connected"),
   _propertyTrusted("Trusted"),
   _propertyBlocked("Blocked"),
   _propertyAlias("Alias"),
   _propertyAdapter("Adapter"),
   _propertyModalias("Modalias"),
   _propertyRSSI("RSSI"),
   _propertyVendor("Vendor"),
   _propertyVendorSource("VendorSource"),
   _propertyProduct("Product"),
   _propertyMapInfo("MapInfo"),
   _propertyConnectedService("ConnectedService"),
   _propertyVersion("Version"),
   _propertyPBAPInfo("PBAPInfo"),
   _propertyMode("Mode"),
   _propertyRole("Role"),
   _propertyEnableAvpPause("EnableAvpPause")
{
   _string2EnumList[_propertyAddress] = (int)DEVICE_ADDRESS;
   _string2EnumList[_propertyClass] = (int)DEVICE_CLASS;
   _string2EnumList[_propertyIcon] = (int)DEVICE_ICON;
   _string2EnumList[_propertyUUIDs] = (int)DEVICE_UUIDS;
   _string2EnumList[_propertyPaired] = (int)DEVICE_PAIRED;
   _string2EnumList[_propertyConnected] = (int)DEVICE_CONNECTED;
   _string2EnumList[_propertyTrusted] = (int)DEVICE_TRUSTED;
   _string2EnumList[_propertyBlocked] = (int)DEVICE_BLOCKED;
   _string2EnumList[_propertyAlias] = (int)DEVICE_ALIAS;
   _string2EnumList[_propertyAdapter] = (int)DEVICE_ADAPTER;
   _string2EnumList[_propertyModalias] = (int)DEVICE_MODALIAS;
   _string2EnumList[_propertyRSSI] = (int)DEVICE_RSSI;
   _string2EnumList[_propertyVendor] = (int)DEVICE_VENDOR;
   _string2EnumList[_propertyVendorSource] = (int)DEVICE_VENDORSOURCE;
   _string2EnumList[_propertyProduct] = (int)DEVICE_PRODUCT;
   _string2EnumList[_propertyMapInfo] = (int)DEVICE_MAPINFO;
   _string2EnumList[_propertyConnectedService] = (int)DEVICE_CONNECTEDSERVICE;
   _string2EnumList[_propertyVersion] = (int)DEVICE_VERSION;
   _string2EnumList[_propertyPBAPInfo] = (int)DEVICE_PBAPINFO;
   _string2EnumList[_propertyMode] = (int)DEVICE_MODE;
   _string2EnumList[_propertyRole] = (int)DEVICE_ROLE;
   _string2EnumList[_propertyEnableAvpPause] = (int)DEVICE_ENABLEAVPPAUSE;

   _enum2StringList[(int)DEVICE_ADDRESS] = &_propertyAddress;
   _enum2StringList[(int)DEVICE_CLASS] = &_propertyClass;
   _enum2StringList[(int)DEVICE_ICON] = &_propertyIcon;
   _enum2StringList[(int)DEVICE_UUIDS] = &_propertyUUIDs;
   _enum2StringList[(int)DEVICE_PAIRED] = &_propertyPaired;
   _enum2StringList[(int)DEVICE_CONNECTED] = &_propertyConnected;
   _enum2StringList[(int)DEVICE_TRUSTED] = &_propertyTrusted;
   _enum2StringList[(int)DEVICE_BLOCKED] = &_propertyBlocked;
   _enum2StringList[(int)DEVICE_ALIAS] = &_propertyAlias;
   _enum2StringList[(int)DEVICE_ADAPTER] = &_propertyAdapter;
   _enum2StringList[(int)DEVICE_MODALIAS] = &_propertyModalias;
   _enum2StringList[(int)DEVICE_RSSI] = &_propertyRSSI;
   _enum2StringList[(int)DEVICE_VENDOR] = &_propertyVendor;
   _enum2StringList[(int)DEVICE_VENDORSOURCE] = &_propertyVendorSource;
   _enum2StringList[(int)DEVICE_PRODUCT] = &_propertyProduct;
   _enum2StringList[(int)DEVICE_MAPINFO] = &_propertyMapInfo;
   _enum2StringList[(int)DEVICE_CONNECTEDSERVICE] = &_propertyConnectedService;
   _enum2StringList[(int)DEVICE_VERSION] = &_propertyVersion;
   _enum2StringList[(int)DEVICE_PBAPINFO] = &_propertyPBAPInfo;
   _enum2StringList[(int)DEVICE_MODE] = &_propertyMode;
   _enum2StringList[(int)DEVICE_ROLE] = &_propertyRole;
   _enum2StringList[(int)DEVICE_ENABLEAVPPAUSE] = &_propertyEnableAvpPause;
}

EvolutionGeniviDbusDeviceProperties::~EvolutionGeniviDbusDeviceProperties()
{
}

DeviceProperty EvolutionGeniviDbusDeviceProperties::getProperty2Enum(const ::std::string& value) const
{
   return (DeviceProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusDeviceProperties::getProperty2String(const DeviceProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusDeviceProperties::getProperty2StringTrace(const DeviceProperty value) const
{
   if(DEVICE_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
