/**
 * @file EvolutionGeniviDbusAgentServer.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS stub for Agent.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS stub for Agent.
 */

#include "EvolutionGeniviDbusAgentServer.h"
#include "IEvolutionGeniviDbusAgentCallbackIf.h"

using namespace ::org::bluez::Agent;

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusAgentServer::EvolutionGeniviDbusAgentServer() :
AgentStub("evoAgentPort")
{
   _callbackIf = 0;
}

EvolutionGeniviDbusAgentServer::EvolutionGeniviDbusAgentServer(IEvolutionGeniviDbusAgentCallbackIf* callbackIf) :
AgentStub("evoAgentPort")
{
   _callbackIf = callbackIf;
}

EvolutionGeniviDbusAgentServer::~EvolutionGeniviDbusAgentServer()
{
   _callbackIf = 0;
}

// AgentStub implementation --- start
void EvolutionGeniviDbusAgentServer::onReleaseRequest(const ::boost::shared_ptr< ReleaseRequest >& request)
{
   // HINT: act is provided via request->getAct()
   // HINT: act shall be given to callback function
   // HINT: act shall be used to call send function

   if(0 != _callbackIf)
   {
      _callbackIf->onReleaseRequest(request, request->getAct());
   }
}

void EvolutionGeniviDbusAgentServer::onRequestPinCodeRequest(const ::boost::shared_ptr< RequestPinCodeRequest >& request)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onRequestPinCodeRequest(request, request->getAct());
   }
}

void EvolutionGeniviDbusAgentServer::onDisplayPinCodeRequest(const ::boost::shared_ptr< DisplayPinCodeRequest >& request)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onDisplayPinCodeRequest(request, request->getAct());
   }
}

void EvolutionGeniviDbusAgentServer::onRequestPasskeyRequest(const ::boost::shared_ptr< RequestPasskeyRequest >& request)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onRequestPasskeyRequest(request, request->getAct());
   }
}

void EvolutionGeniviDbusAgentServer::onRequestConfirmationRequest(const ::boost::shared_ptr< RequestConfirmationRequest >& request)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onRequestConfirmationRequest(request, request->getAct());
   }
}

void EvolutionGeniviDbusAgentServer::onCancelRequest(const ::boost::shared_ptr< CancelRequest >& request)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onCancelRequest(request, request->getAct());
   }
}

void EvolutionGeniviDbusAgentServer::onCancelRequestRequest(const ::boost::shared_ptr< CancelRequestRequest >& request)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onCancelRequestRequest(request, request->getAct());
   }
}

void EvolutionGeniviDbusAgentServer::onAuthorizeServiceRequest(const ::boost::shared_ptr< AuthorizeServiceRequest >& request)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onAuthorizeServiceRequest(request, request->getAct());
   }
}

void EvolutionGeniviDbusAgentServer::onRequestAuthorizationRequest(const ::boost::shared_ptr< RequestAuthorizationRequest >& request)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onRequestAuthorizationRequest(request, request->getAct());
   }
}

void EvolutionGeniviDbusAgentServer::onRequestLinkkeyRequest(const ::boost::shared_ptr< RequestLinkkeyRequest >& request)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onRequestLinkkeyRequest(request, request->getAct());
   }
}

void EvolutionGeniviDbusAgentServer::onDisplayPasskeyRequest(const ::boost::shared_ptr< DisplayPasskeyRequest >& request)
{
   if(0 != _callbackIf)
   {
      _callbackIf->onDisplayPasskeyRequest(request, request->getAct());
   }
}
// AgentStub implementation --- end

} //evolution
} //ccdbusif
