/**
 * @file EvolutionGeniviDbusAgentManagerProperties.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for AgentManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for AgentManager.
 */

#include "EvolutionGeniviDbusAgentManagerProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusAgentManagerProperties::EvolutionGeniviDbusAgentManagerProperties() : DbusProperties("AgentManager"),
   _capabilityDisplayOnly("DisplayOnly"),
   _capabilityDisplayYesNo("DisplayYesNo"),
   _capabilityKeyboardOnly("KeyboardOnly"),
   _capabilityNoInputNoOutput("NoInputNoOutput"),
   _capabilityKeyboardDisplay("KeyboardDisplay")
{
   _capability2EnumList[_capabilityDisplayOnly] = (int)AGENT_MANAGER_CAPABILITY_DISPLAYONLY;
   _capability2EnumList[_capabilityDisplayYesNo] = (int)AGENT_MANAGER_CAPABILITY_DISPLAYYESNO;
   _capability2EnumList[_capabilityKeyboardOnly] = (int)AGENT_MANAGER_CAPABILITY_KEYBOARDONLY;
   _capability2EnumList[_capabilityNoInputNoOutput] = (int)AGENT_MANAGER_CAPABILITY_NOINPUTNOOUTPUT;
   _capability2EnumList[_capabilityKeyboardDisplay] = (int)AGENT_MANAGER_CAPABILITY_KEYBOARDDISPLAY;

   _enum2capabilityList[(int)AGENT_MANAGER_CAPABILITY_DISPLAYONLY] = &_capabilityDisplayOnly;
   _enum2capabilityList[(int)AGENT_MANAGER_CAPABILITY_DISPLAYYESNO] = &_capabilityDisplayYesNo;
   _enum2capabilityList[(int)AGENT_MANAGER_CAPABILITY_KEYBOARDONLY] = &_capabilityKeyboardOnly;
   _enum2capabilityList[(int)AGENT_MANAGER_CAPABILITY_NOINPUTNOOUTPUT] = &_capabilityNoInputNoOutput;
   _enum2capabilityList[(int)AGENT_MANAGER_CAPABILITY_KEYBOARDDISPLAY] = &_capabilityKeyboardDisplay;
}

EvolutionGeniviDbusAgentManagerProperties::~EvolutionGeniviDbusAgentManagerProperties()
{
   _capability2EnumList.clear();
   _enum2capabilityList.clear();
}

AgentManagerCapabilitySuppValues EvolutionGeniviDbusAgentManagerProperties::getCapability2Enum(const ::std::string& value) const
{
   return (AgentManagerCapabilitySuppValues)convertString2Enum(_capability2EnumList, value);
}

const ::std::string& EvolutionGeniviDbusAgentManagerProperties::getCapability2String(const AgentManagerCapabilitySuppValues value) const
{
   if(AGENT_MANAGER_CAPABILITY_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String(_enum2capabilityList, (const int)value, false);
   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
