/**
 * @file EvolutionGeniviDbusAgentFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for Agent.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Agent.
 */

#include "EvolutionGeniviDbusAgentFactory.h"
#include "EvolutionGeniviDbusAgentStubIf.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusAgentFactory::EvolutionGeniviDbusAgentFactory() :
_proxy(0),
_testProxy(0)
{
}

EvolutionGeniviDbusAgentFactory::~EvolutionGeniviDbusAgentFactory()
{
   _proxy = 0;
   _testProxy = 0;
}

EvolutionGeniviDbusAgentFactory& EvolutionGeniviDbusAgentFactory::getInstance(void)
{
   static EvolutionGeniviDbusAgentFactory factory;
   return factory;
}

IEvolutionGeniviDbusAgentSendRequestIf* EvolutionGeniviDbusAgentFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(0 != _proxy)
   {
      // already created
   }
   else
   {
      _proxy = new EvolutionGeniviDbusAgentStubIf(client, _testProxy);
   }

   return _proxy;
}

void EvolutionGeniviDbusAgentFactory::destroyProxy(void)
{
   if(0 != _proxy)
   {
      delete _proxy;
      _proxy = 0;
   }
}

void EvolutionGeniviDbusAgentFactory::setProxyForTesting(IEvolutionGeniviDbusAgentTestStubIf* testProxy)
{
   _testProxy = testProxy;
}

} //evolution
} //ccdbusif
