/**
 * @file EvolutionGeniviDbusAdapterFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for Adapter.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Adapter.
 */

#include "EvolutionGeniviDbusAdapterFactory.h"
#include "EvolutionGeniviDbusAdapterProxyIf.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusAdapterFactory::EvolutionGeniviDbusAdapterFactory() :
_proxy(0),
_testProxy(0)
{
}

EvolutionGeniviDbusAdapterFactory::~EvolutionGeniviDbusAdapterFactory()
{
   _proxy = 0;
   _testProxy = 0;
}

EvolutionGeniviDbusAdapterFactory& EvolutionGeniviDbusAdapterFactory::getInstance(void)
{
   static EvolutionGeniviDbusAdapterFactory factory;
   return factory;
}

IEvolutionGeniviDbusAdapterSendRequestIf* EvolutionGeniviDbusAdapterFactory::getProxy(ICcDbusIfControllerClient* client)
{
   if(0 != _proxy)
   {
      // already created
   }
   else
   {
      _proxy = new EvolutionGeniviDbusAdapterProxyIf(client, _testProxy);
   }

   return _proxy;
}

void EvolutionGeniviDbusAdapterFactory::destroyProxy(void)
{
   if(0 != _proxy)
   {
      delete _proxy;
      _proxy = 0;
   }
}

void EvolutionGeniviDbusAdapterFactory::setProxyForTesting(IEvolutionGeniviDbusAdapterTestProxyIf* testProxy)
{
   _testProxy = testProxy;
}

} //evolution
} //ccdbusif
