/**
 * @file IEvolutionGeniviDbusTraceCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Trace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for Trace.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_TRACE_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_TRACE_CALLBACK_IF_H_

#include "org/bluez/evo/TraceProxy.h"

using namespace ::org::bluez::evo::Trace;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for Trace.
 */
class IEvolutionGeniviDbusTraceCallbackIf :
   // from org/bluez/evo/TraceProxy.h --- start
   public DebugTraceConfigCallbackIF,
   public ProtocolTraceConfigCallbackIF,
   public ReportDebugTraceCallbackIF,
   public ReportProtocolTraceCallbackIF,
   public FatalErrorCallbackIF,
   public GeneralErrorCallbackIF
   // from org/bluez/evo/TraceProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusTraceCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/evo/TraceProxy implementation --- start
   virtual void onDebugTraceConfigError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< DebugTraceConfigError >& error) = 0;

   virtual void onDebugTraceConfigResponse(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< DebugTraceConfigResponse >& response) = 0;

   virtual void onProtocolTraceConfigError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ProtocolTraceConfigError >& error) = 0;

   virtual void onProtocolTraceConfigResponse(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ProtocolTraceConfigResponse >& response) = 0;

   virtual void onReportDebugTraceError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceError >& error) = 0;

   virtual void onReportDebugTraceSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportDebugTraceSignal >& signal) = 0;

   virtual void onReportProtocolTraceError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportProtocolTraceError >& error) = 0;

   virtual void onReportProtocolTraceSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< ReportProtocolTraceSignal >& signal) = 0;

   virtual void onFatalErrorError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorError >& error) = 0;

   virtual void onFatalErrorSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< FatalErrorSignal >& signal) = 0;

   virtual void onGeneralErrorError(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< GeneralErrorError >& error) = 0;

   virtual void onGeneralErrorSignal(const ::boost::shared_ptr< TraceProxy >& proxy, const ::boost::shared_ptr< GeneralErrorSignal >& signal) = 0;
   // org/bluez/evo/TraceProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_TRACE_CALLBACK_IF_H_
