/**
 * @file IEvolutionGeniviDbusSppCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Spp.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for Spp.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_SPP_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_SPP_CALLBACK_IF_H_

#include "org/alps/evo/SPPProxy.h"

using namespace ::org::alps::evo::SPP;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for Spp.
 */
class IEvolutionGeniviDbusSppCallbackIf :
   // from org/alps/evo/SPPProxy.h --- start
   public BtApplSppDataReqCallbackIF,
   public BtApplSppSetUuidReqCallbackIF,
   public BtApplSppFlowCtrlReqCallbackIF,
   public BtApplSppDataCfmCallbackIF,
   public BtApplSppDataIndCallbackIF,
   public BtApplSppSendIndCallbackIF,
   public BtApplSppSetUuidCfmCallbackIF,
   public BtApplSppFlowCtrlCfmCallbackIF,
   public BtApplSppDataSendFcIndCallbackIF
   // from org/alps/evo/SPPProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusSppCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/alps/evo/SPPProxy implementation --- start
   virtual void onBtApplSppDataReqError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataReqError >& error) = 0;

   virtual void onBtApplSppDataReqResponse(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataReqResponse >& response) = 0;

   virtual void onBtApplSppSetUuidReqError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSetUuidReqError >& error) = 0;

   virtual void onBtApplSppSetUuidReqResponse(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSetUuidReqResponse >& response) = 0;

   virtual void onBtApplSppFlowCtrlReqError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppFlowCtrlReqError >& error) = 0;

   virtual void onBtApplSppFlowCtrlReqResponse(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppFlowCtrlReqResponse >& response) = 0;

   virtual void onBtApplSppDataCfmError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataCfmError >& error) = 0;

   virtual void onBtApplSppDataCfmSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataCfmSignal >& signal) = 0;

   virtual void onBtApplSppDataIndError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataIndError >& error) = 0;

   virtual void onBtApplSppDataIndSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataIndSignal >& signal) = 0;

   virtual void onBtApplSppSendIndError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSendIndError >& error) = 0;

   virtual void onBtApplSppSendIndSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSendIndSignal >& signal) = 0;

   virtual void onBtApplSppSetUuidCfmError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSetUuidCfmError >& error) = 0;

   virtual void onBtApplSppSetUuidCfmSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppSetUuidCfmSignal >& signal) = 0;

   virtual void onBtApplSppFlowCtrlCfmError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppFlowCtrlCfmError >& error) = 0;

   virtual void onBtApplSppFlowCtrlCfmSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppFlowCtrlCfmSignal >& signal) = 0;

   virtual void onBtApplSppDataSendFcIndError(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataSendFcIndError >& error) = 0;

   virtual void onBtApplSppDataSendFcIndSignal(const ::boost::shared_ptr< SPPProxy >& proxy, const ::boost::shared_ptr< BtApplSppDataSendFcIndSignal >& signal) = 0;
   // org/alps/evo/SPPProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_SPP_CALLBACK_IF_H_
