/**
 * @file IEvolutionGeniviDbusServiceCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Service.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for Service.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_SERVICE_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_SERVICE_CALLBACK_IF_H_

#include "org/bluez/ServiceProxy.h"

using namespace ::org::bluez::Service;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for Service.
 */
class IEvolutionGeniviDbusServiceCallbackIf :
   // from org/bluez/ServiceProxy.h --- start
   public ConnectCallbackIF,
   public DisconnectCallbackIF,
   public RemoteUUIDCallbackIF,
   public StateCallbackIF,
   public DeviceCallbackIF,
   public VersionCallbackIF
   // from org/bluez/ServiceProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusServiceCallbackIf() {}

   // HINT: these interfaces are called within context of thread defined in CcDbusIfAppLibrary.cma ("ccDbusIfThread")

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/ServiceProxy implementation --- start
   virtual void onConnectError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ConnectError >& error) = 0;

   virtual void onConnectResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ConnectResponse >& response) = 0;

   virtual void onDisconnectError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error) = 0;

   virtual void onDisconnectResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response) = 0;

   virtual void onRemoteUUIDError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< RemoteUUIDError >& error) = 0;

   virtual void onRemoteUUIDUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< RemoteUUIDUpdate >& update) = 0;

   virtual void onStateError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< StateError >& error) = 0;

   virtual void onStateUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< StateUpdate >& update) = 0;

   virtual void onDeviceError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DeviceError >& error) = 0;

   virtual void onDeviceUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DeviceUpdate >& update) = 0;

   virtual void onVersionError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< VersionError >& error) = 0;

   virtual void onVersionUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< VersionUpdate >& update) = 0;
   // org/bluez/ServiceProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_SERVICE_CALLBACK_IF_H_
