/**
 * @file IEvolutionGeniviDbusSerialTestProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Test Proxy Interface for Serial.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS test proxy for Serial.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_SERIAL_TEST_PROXY_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_SERIAL_TEST_PROXY_IF_H_

#include "CcDbusIfTypes.h"
#include <boost/shared_ptr.hpp>

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusSerialCallbackIf;

/**
 * Test proxy interface class for Serial.
 */
class IEvolutionGeniviDbusSerialTestProxyIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusSerialTestProxyIf() {}

   /**
    * Create proxy.
    *
    * @param[in] callback: callback handler
    * @param[in] port: port
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void createProxy(IEvolutionGeniviDbusSerialCallbackIf& callback, const ::std::string& port, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Destroy proxy.
    *
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void destroyProxy(const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Destroy all proxies.
    */
   virtual void destroyAllProxies(void) = 0;

   /**
    * Send SendData Request.
    *
    * @param[in] callback: callback handler
    * @param[in] objPath: object path of service
    * @param[in] data: SPP data
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendSendDataRequest(IEvolutionGeniviDbusSerialCallbackIf& callback, const ::std::string& objPath, const ::std::vector< uint8 >& data) = 0;

   /**
    * Send FlowCtrlRecv Get.
    *
    * @param[in] callback: callback handler
    * @param[in] objPath: object path of service
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendFlowCtrlRecvGet(IEvolutionGeniviDbusSerialCallbackIf& callback, const ::std::string& objPath) = 0;

   /**
    * Send FlowCtrlRecv Set.
    *
    * @param[in] callback: callback handler
    * @param[in] objPath: object path of service
    * @param[in] flowCtrlRecv: flowCtrlRecv command
    */
   virtual void sendFlowCtrlRecvSet(IEvolutionGeniviDbusSerialCallbackIf& callback, const ::std::string& objPath, const ::std::string& flowCtrlRecv) = 0;
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_SERIAL_TEST_PROXY_IF_H_
