/**
 * @file IEvolutionGeniviDbusSerialCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Serial.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for Serial.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_SERIAL_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_SERIAL_CALLBACK_IF_H_

#include "CcDbusIfTypes.h"

#include "org/bluez/Serial.h"

using namespace ::org::bluez::Serial;

namespace ccdbusif {

/**
 * Callback interface class for Serial.
 */
class IEvolutionGeniviDbusSerialCallbackIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusSerialCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   /**
    * Available signal.
    *
    * @param[in] available: available flag
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;

   /**
    * Unavailable signal.
    *
    * @param[in] available: available flag
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    */
   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/SerialProxy implementation --- start
   /**
    * onSendDataError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onSendDataErrorCb(const ::boost::shared_ptr< SendDataError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onSendDataResponse.
    *
    * @param[in] response: response signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onSendDataResponseCb(const ::boost::shared_ptr< SendDataResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onSppDataIndError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onSppDataIndErrorCb(const ::boost::shared_ptr< SppDataIndError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onSppDataIndSignal.
    *
    * @param[in] signal: signal signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onSppDataIndSignalCb(const ::boost::shared_ptr< SppDataIndSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onFlowCtrlSendError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onFlowCtrlSendErrorCb(const ::boost::shared_ptr< FlowCtrlSendError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onFlowCtrlSendSignal.
    *
    * @param[in] signal: signal signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onFlowCtrlSendSignalCb(const ::boost::shared_ptr< FlowCtrlSendSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDeviceFilePathError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDeviceFilePathErrorCb(const ::boost::shared_ptr< DeviceFilePathError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onDeviceFilePathSignal.
    *
    * @param[in] signal: signal signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onDeviceFilePathSignalCb(const ::boost::shared_ptr< DeviceFilePathSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onFlowCtrlRecvError.
    *
    * @param[in] error: error signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onFlowCtrlRecvErrorCb(const ::boost::shared_ptr< FlowCtrlRecvError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;

   /**
    * onFlowCtrlRecvUpdate.
    *
    * @param[in] update: update signal / response
    * @param[in] objPath: object path
    * @param[in] busName: bus name
    * @param[in] busType: bus type
    * @param[in] interfaceName: interface name
    */
   virtual void onFlowCtrlRecvUpdateCb(const ::boost::shared_ptr< FlowCtrlRecvUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string()) = 0;
   // org/bluez/SerialProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_SERIAL_CALLBACK_IF_H_
