/**
 * @file IEvolutionGeniviDbusHfpVoiceCallSendRequestIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Send Request Interface for HfpVoiceCall.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS send request for HfpVoiceCall.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_SEND_REQUEST_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_SEND_REQUEST_IF_H_

#include <stdbool.h> // <cstdbool> is marked with C++11
#include <string>

#include "asf/core/Types.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusHfpVoiceCallCallbackIf;

/**
 * Send request interface class for HfpVoiceCall.
 */
class IEvolutionGeniviDbusHfpVoiceCallSendRequestIf
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusHfpVoiceCallSendRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callbackIf: callback handler
    * @param[in] enableProxy: flag to enable/disable proxy
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpVoiceCallCallbackIf* callbackIf, bool enableProxy) = 0;

   /**
    * Handle signal for created call.
    *
    * @param[in] objPath: object path of created call
    */
   virtual void callCreated(const ::std::string& objPath) = 0;

   /**
    * Handle signal for removed call.
    *
    * @param[in] objPath: object path of removed call
    */
   virtual void callRemoved(const ::std::string& objPath) = 0;

   /**
    * Send GetProperties Request.
    *
    * @param[in] objPath: object path of call
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath) = 0;

   /**
    * Send Hangup Request.
    *
    * @param[in] objPath: object path of call
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendHangupRequest(const ::std::string& objPath) = 0;

   /**
    * Send Answer Request.
    *
    * @param[in] objPath: object path of call
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendAnswerRequest(const ::std::string& objPath) = 0;

   /**
    * Send Hold Request.
    *
    * @param[in] objPath: object path of call
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendHoldRequest(const ::std::string& objPath) = 0;
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_SEND_REQUEST_IF_H_
