/**
 * @file IEvolutionGeniviDbusHfpVoiceCallManagerCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpVoiceCallManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for HfpVoiceCallManager.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_MANAGER_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_MANAGER_CALLBACK_IF_H_

#include "org/ofono/VoiceCallManagerProxy.h"

using namespace ::org::ofono::VoiceCallManager;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for HfpVoiceCallManager.
 */
class IEvolutionGeniviDbusHfpVoiceCallManagerCallbackIf :
   // from org/ofono/VoiceCallManagerProxy.h --- start
   public GetPropertiesCallbackIF,
   public GetCallsCallbackIF,
   public DialCallbackIF,
   public MemDialCallbackIF,
   public RedialCallbackIF,
   public SwapCallsCallbackIF,
   public ReleaseAndAnswerCallbackIF,
   public ReleaseAndSwapCallbackIF,
   public HoldAndAnswerCallbackIF,
   public HangupAllCallbackIF,
   public PrivateChatCallbackIF,
   public CreateMultipartyCallbackIF,
   public HangupMultipartyCallbackIF,
   public SendTonesCallbackIF,
   public CallAddedCallbackIF,
   public CallRemovedCallbackIF,
   public PropertyChangedCallbackIF
   // from org/ofono/VoiceCallManagerProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusHfpVoiceCallManagerCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/VoiceCallManagerProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;

   virtual void onGetCallsError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetCallsError >& error) = 0;

   virtual void onGetCallsResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetCallsResponse >& response) = 0;

   virtual void onDialError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< DialError >& error) = 0;

   virtual void onDialResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< DialResponse >& response) = 0;

   virtual void onMemDialError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MemDialError >& error) = 0;

   virtual void onMemDialResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MemDialResponse >& response) = 0;

   virtual void onRedialError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< RedialError >& error) = 0;

   virtual void onRedialResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< RedialResponse >& response) = 0;

   virtual void onSwapCallsError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SwapCallsError >& error) = 0;

   virtual void onSwapCallsResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SwapCallsResponse >& response) = 0;

   virtual void onReleaseAndAnswerError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< ReleaseAndAnswerError >& error) = 0;

   virtual void onReleaseAndAnswerResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< ReleaseAndAnswerResponse >& response) = 0;

   virtual void onReleaseAndSwapError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< ReleaseAndSwapError >& error) = 0;

   virtual void onReleaseAndSwapResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< ReleaseAndSwapResponse >& response) = 0;

   virtual void onHoldAndAnswerError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HoldAndAnswerError >& error) = 0;

   virtual void onHoldAndAnswerResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HoldAndAnswerResponse >& response) = 0;

   virtual void onHangupAllError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupAllError >& error) = 0;

   virtual void onHangupAllResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupAllResponse >& response) = 0;

   virtual void onPrivateChatError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PrivateChatError >& error) = 0;

   virtual void onPrivateChatResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PrivateChatResponse >& response) = 0;

   virtual void onCreateMultipartyError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CreateMultipartyError >& error) = 0;

   virtual void onCreateMultipartyResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CreateMultipartyResponse >& response) = 0;

   virtual void onHangupMultipartyError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupMultipartyError >& error) = 0;

   virtual void onHangupMultipartyResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupMultipartyResponse >& response) = 0;

   virtual void onSendTonesError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SendTonesError >& error) = 0;

   virtual void onSendTonesResponse(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SendTonesResponse >& response) = 0;

   virtual void onCallAddedError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallAddedError >& error) = 0;

   virtual void onCallAddedSignal(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallAddedSignal >& signal) = 0;

   virtual void onCallRemovedError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallRemovedError >& error) = 0;

   virtual void onCallRemovedSignal(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallRemovedSignal >& signal) = 0;

   virtual void onPropertyChangedError(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;
   // org/ofono/VoiceCallManagerProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_MANAGER_CALLBACK_IF_H_
