/**
 * @file IEvolutionGeniviDbusHfpVoiceCallCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpVoiceCall.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for HfpVoiceCall.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_CALLBACK_IF_H_

#include "org/ofono/VoiceCallProxy.h"

using namespace ::org::ofono::VoiceCall;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for HfpVoiceCall.
 */
class IEvolutionGeniviDbusHfpVoiceCallCallbackIf :
   // from org/ofono/VoiceCallProxy.h --- start
   public GetPropertiesCallbackIF,
   public HangupCallbackIF,
   public AnswerCallbackIF,
   public HoldCallbackIF,
   public PropertyChangedCallbackIF
   // from org/ofono/VoiceCallProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusHfpVoiceCallCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/VoiceCallProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;

   virtual void onHangupError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HangupError >& error) = 0;

   virtual void onHangupResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HangupResponse >& response) = 0;

   virtual void onAnswerError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< AnswerError >& error) = 0;

   virtual void onAnswerResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< AnswerResponse >& response) = 0;

   virtual void onHoldError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HoldError >& error) = 0;

   virtual void onHoldResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HoldResponse >& response) = 0;

   virtual void onPropertyChangedError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;
   // org/ofono/VoiceCallProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_CALLBACK_IF_H_
