/**
 * @file IEvolutionGeniviDbusHfpSiriCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpSiri.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for HfpSiri.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_HFP_SIRI_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_HFP_SIRI_CALLBACK_IF_H_

#include "org/ofono/evo/SiriProxy.h"

using namespace ::org::ofono::evo::Siri;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for HfpSiri.
 */
class IEvolutionGeniviDbusHfpSiriCallbackIf :
   // from org/ofono/evo/SiriProxy.h --- start
   public GetPropertiesCallbackIF,
   public EnableCallbackIF,
   public SetNRCallbackIF,
   public SetPropertyCallbackIF,
   public PropertyChangedCallbackIF
   // from org/ofono/evo/SiriProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusHfpSiriCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/evo/SiriProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;

   virtual void onEnableError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< EnableError >& error) = 0;

   virtual void onEnableResponse(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< EnableResponse >& response) = 0;

   virtual void onSetNRError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< SetNRError >& error) = 0;

   virtual void onSetNRResponse(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< SetNRResponse >& response) = 0;

   virtual void onSetPropertyError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error) = 0;

   virtual void onSetPropertyResponse(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response) = 0;

   virtual void onPropertyChangedError(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< SiriProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;
   // org/ofono/evo/SiriProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_HFP_SIRI_CALLBACK_IF_H_
