/**
 * @file IEvolutionGeniviDbusHfpModemCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpModem.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for HfpModem.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_HFP_MODEM_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_HFP_MODEM_CALLBACK_IF_H_

#include "org/ofono/ModemProxy.h"

using namespace ::org::ofono::Modem;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for HfpModem.
 */
class IEvolutionGeniviDbusHfpModemCallbackIf :
   // from org/ofono/ModemProxy.h --- start
   public GetPropertiesCallbackIF,
   public SetPropertyCallbackIF,
   public AcceptSCOConnectCallbackIF,
   public PropertyChangedCallbackIF,
   public SCOConnectRequestCallbackIF
   // from org/ofono/ModemProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusHfpModemCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/ModemProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;

   virtual void onSetPropertyError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error) = 0;

   virtual void onSetPropertyResponse(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response) = 0;

   virtual void onAcceptSCOConnectError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< AcceptSCOConnectError >& error) = 0;

   virtual void onAcceptSCOConnectResponse(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< AcceptSCOConnectResponse >& response) = 0;

   virtual void onPropertyChangedError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;

   virtual void onSCOConnectRequestError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< SCOConnectRequestError >& error) = 0;

   virtual void onSCOConnectRequestSignal(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< SCOConnectRequestSignal >& signal) = 0;
   // org/ofono/ModemProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_HFP_MODEM_CALLBACK_IF_H_
