/**
 * @file IEvolutionGeniviDbusHfpHandsfreeCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for HfpHandsfree.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for HfpHandsfree.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_HFP_HANDSFREE_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_HFP_HANDSFREE_CALLBACK_IF_H_

#include "org/ofono/HandsfreeProxy.h"

using namespace ::org::ofono::Handsfree;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for HfpHandsfree.
 */
class IEvolutionGeniviDbusHfpHandsfreeCallbackIf :
   // from org/ofono/HandsfreeProxy.h --- start
   public GetPropertiesCallbackIF,
   public SetPropertyCallbackIF,
   public RequestPhoneNumberCallbackIF,
   public GetSubscriberCallbackIF,
   public SendCustomATCommandCallbackIF,
   public PropertyChangedCallbackIF,
   public RecvATCommandCallbackIF
   // from org/ofono/HandsfreeProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusHfpHandsfreeCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/ofono/HandsfreeProxy implementation --- start
   virtual void onGetPropertiesError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;

   virtual void onSetPropertyError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error) = 0;

   virtual void onSetPropertyResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response) = 0;

   virtual void onRequestPhoneNumberError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RequestPhoneNumberError >& error) = 0;

   virtual void onRequestPhoneNumberResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RequestPhoneNumberResponse >& response) = 0;

   virtual void onGetSubscriberError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetSubscriberError >& error) = 0;

   virtual void onGetSubscriberResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< GetSubscriberResponse >& response) = 0;

   virtual void onSendCustomATCommandError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SendCustomATCommandError >& error) = 0;

   virtual void onSendCustomATCommandResponse(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< SendCustomATCommandResponse >& response) = 0;

   virtual void onPropertyChangedError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;

   virtual void onRecvATCommandError(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RecvATCommandError >& error) = 0;

   virtual void onRecvATCommandSignal(const ::boost::shared_ptr< HandsfreeProxy >& proxy, const ::boost::shared_ptr< RecvATCommandSignal >& signal) = 0;
   // org/ofono/HandsfreeProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_HFP_HANDSFREE_CALLBACK_IF_H_
